/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class DCssPageRule
extends DCssRule
implements CSSPageRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String m_ident = null;
    private String m_pseudoPage = null;
    private CSSStyleDeclaration m_style = null;

    public DCssPageRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule, String ident, String pseudoPage) {
        super(parentStyleSheet, parentRule);
        this.m_ident = ident;
        this.m_pseudoPage = pseudoPage;
    }

    @Override
    public short getType() {
        return 6;
    }

    @Override
    public String getCssText() {
        String sel = this.getSelectorText();
        return "@page " + sel + (sel.length() > 0 ? " " : "") + this.getStyle().getCssText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 6) {
                throw new DCssException(13, 9);
            }
            this.m_ident = ((DCssPageRule)r).m_ident;
            this.m_pseudoPage = ((DCssPageRule)r).m_pseudoPage;
            this.m_style = ((DCssPageRule)r).m_style;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    @Override
    public String getSelectorText() {
        return String.valueOf(this.m_ident != null ? this.m_ident : "") + (this.m_pseudoPage != null ? ":" + this.m_pseudoPage : "");
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this.m_style;
    }

    protected void setIdent(String ident) {
        this.m_ident = ident;
    }

    protected void setPseudoPage(String pseudoPage) {
        this.m_pseudoPage = pseudoPage;
    }

    public void setStyle(CSSStyleDeclaration style) {
        this.m_style = style;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

