/*******************************************************************************
 * Copyright (c) 2012 eBay Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     eBay Inc. - initial API and implementation
 *******************************************************************************/
vjo.ctype("org.eclipse.vjet.vsf.utils.Form")
.needs("org.eclipse.vjet.vsf.document.Form","")
.props({
	sNVPAIR : "NVPAIR",
	sJSON : "JSON",
	
	/**
	* Retrieve the data from a form to a name-value pair string. The values
	* are combined with '&' in the string.
	*
	* @param {String} formId
	*        a string id of the form
	* @param {String}
	*        the string contains with all values of the form, which is combined
	*        with '&' 
	*/
	//> public String getDataAsNVPairStr(String);
	getDataAsNVPairStr : function(psFormId) {
		return this.getData(psFormId,this.sNVPAIR);
	},
	
	/**
	* This function does not yet implemented. Keep it as the 'private'.
	*/
	//> public String getDataAsJSONStr(String);
	getDataAsJSONStr : function(psFormId) {
		alert('getDataAsJSONStr not yet implemented');
		//return this.getData(psFormId,this.sJSON);
		return 'getDataAsJSONStr not yet implemented';
	},

	//> private String getData(String,String);
	getData : function(psFormId, psPayloadType)
	{
		var F = org.eclipse.vjet.vsf.document.Form,f = F.get(psFormId),es,e,d="",t,v,n;
		if(f) {
			es = f.elements;
			for(var i=0, l=es.length;i<l;i++){
				e = es[i];
				t = e.type.toLowerCase();
				v = e.value;
				//v = encodeURIComponent(v);
				if(((t=="radio"||t=="checkbox") && !e.checked)||t=="button"){
				}else {
					n = e.name||e.id;
					if(t=="select-multiple"){
						for(var j=0, ln=e.options.length;j<ln;j++){
							if(e.options[j].selected){
								if(d) d += "&";
								d += n + "=" + e.options[j].value;
							}
						}
					} else {
						if(d) d += "&";
						d += n + "=" + v;
					}
				}
			}
		}
		return d;
	}
})
.endType();
