/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.resource.ctx.ResourceProcessCtx;
import org.eclipse.vjet.dsf.resource.x.IResourceAggregationModeResolver;

public class ResourceUtil {
    public static URL modify(URL url, IResourceAggregationModeResolver.AggregationMode mode) {
        return ResourceUtil.modify(url, mode, new ResourceProcessCtx());
    }

    public static URL modify(URL url, IResourceAggregationModeResolver.AggregationMode mode, ResourceProcessCtx resourceProcessCtx) {
        int version;
        String checksum;
        String userAgent;
        String paramJoin;
        boolean isModified = false;
        String externalForm = url.toExternalForm();
        String string = paramJoin = externalForm.contains("?") ? "&" : "?";
        if (DsfCtx.ctx().isResourceDebugEnabled()) {
            if (externalForm.contains("#")) {
                externalForm = externalForm.replace("#", String.valueOf(paramJoin) + "hint=");
                paramJoin = "&";
                isModified = true;
            }
            if (mode == IResourceAggregationModeResolver.AggregationMode.DYNAMIC) {
                externalForm = externalForm.replace(".ebaystatic.", ".ebay.");
                String debugParameters = "debug=true&loadMode=2&obfuscate=false&optimize=false";
                externalForm = String.valueOf(externalForm) + paramJoin + debugParameters;
                isModified = true;
            }
        }
        if ((userAgent = DsfCtx.ctx().getUserAgent()) != null && (userAgent.contains("MSIE 6.") || userAgent.contains("BlackBerry")) && externalForm.contains("#")) {
            externalForm = externalForm.substring(0, externalForm.indexOf("#"));
            isModified = true;
        }
        if (resourceProcessCtx.isDataUriEnabled() && mode == IResourceAggregationModeResolver.AggregationMode.DYNAMIC && ResourceUtil.isDataUriSupported(userAgent)) {
            String dataUriParam = String.valueOf(paramJoin) + "dataUri=true";
            paramJoin = "&";
            int maxRpt = resourceProcessCtx.getDataUriMaxRepeatCount();
            if (maxRpt > 0) {
                dataUriParam = String.valueOf(dataUriParam) + "&maxRpt=" + maxRpt;
            }
            externalForm = externalForm.contains("#") ? externalForm.replace("#", String.valueOf(dataUriParam) + "#") : String.valueOf(externalForm) + dataUriParam;
            isModified = true;
        }
        if (mode == IResourceAggregationModeResolver.AggregationMode.DYNAMIC && (checksum = ResourceUtil.extractChecksum(url)) != null && (version = 1) >= 0) {
            String cacheBusterParam = String.valueOf(paramJoin) + "ver=" + version;
            paramJoin = "&";
            externalForm = externalForm.contains("#") ? externalForm.replace("#", String.valueOf(cacheBusterParam) + "#") : String.valueOf(externalForm) + cacheBusterParam;
            isModified = true;
        }
        if (isModified) {
            try {
                return new URL(externalForm);
            }
            catch (MalformedURLException e) {
                Logger.getInstance(ResourceUtil.class).log(LogLevel.ERROR, "Failed to modify resource URL: " + externalForm, (Throwable)e);
            }
        }
        return url;
    }

    public static String extractChecksum(URL url) {
        String path = url.getPath();
        int pos = path.lastIndexOf("/");
        int dotPos = path.indexOf(".");
        if (pos != -1 && dotPos != -1) {
            String checksumLastPart = path.substring(pos - 2, pos);
            String checksumFirstPart = path.substring(pos + 1, dotPos);
            return String.valueOf(checksumLastPart) + checksumFirstPart;
        }
        return null;
    }

    public static boolean isDataUriSupported(String userAgent) {
        if (ResourceUtil.isBrowserVersioAbove(userAgent, BrowserType.IE, "8")) {
            return true;
        }
        if (ResourceUtil.isBrowserVersioAbove(userAgent, BrowserType.FIREFOX, "2")) {
            return true;
        }
        if (ResourceUtil.isBrowserVersioAbove(userAgent, BrowserType.OPERA, "7.2")) {
            return true;
        }
        if (ResourceUtil.isBrowserVersioAbove(userAgent, BrowserType.CHROME, null)) {
            return true;
        }
        return ResourceUtil.isBrowserVersioAbove(userAgent, BrowserType.SAFARI, null);
    }

    public static boolean isBrowserVersioAbove(String userAgent, BrowserType browserType, String version) {
        String name;
        int index;
        if (userAgent == null || browserType == null) {
            return false;
        }
        if (version == null) {
            version = "0";
        }
        if ((index = userAgent.indexOf(name = browserType.getName())) >= 0) {
            String sub = userAgent.substring(index + name.length() + 1);
            return ResourceUtil.isVersionAbove(sub, version);
        }
        return false;
    }

    public static boolean isVersionAbove(String actualVersion, String expectedVersion) {
        String[] eVersions;
        int eLen;
        String aNumberStr = ResourceUtil.getVersionNumber(actualVersion);
        String eNumberStr = ResourceUtil.getVersionNumber(expectedVersion);
        if (aNumberStr.length() == 0 || eNumberStr.length() == 0) {
            return false;
        }
        String[] aVersions = aNumberStr.split("\\.");
        int aLen = aVersions.length;
        int minLen = aLen > (eLen = (eVersions = eNumberStr.split("\\.")).length) ? eLen : aLen;
        int i = 0;
        while (i < minLen) {
            int eVersionNumber;
            int aVersionNumber = new Integer(aVersions[i]);
            if (aVersionNumber > (eVersionNumber = new Integer(eVersions[i]).intValue())) {
                return true;
            }
            if (aVersionNumber < eVersionNumber) {
                return false;
            }
            ++i;
        }
        if (aLen < eLen) {
            i = aLen;
            while (i < eLen) {
                if (new Integer(eVersions[i]) > 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String getVersionNumber(String version) {
        if (version == null) {
            return "";
        }
        int len = version.length();
        if (len == 0) {
            return "";
        }
        char c = version.charAt(0);
        if (c < '0' || c > '9') {
            return "";
        }
        int i = 1;
        while (i < len) {
            c = version.charAt(i);
            if ((c < '0' || c > '9') && c != '.') break;
            ++i;
        }
        i = version.charAt(i - 1) == '.' ? i - 1 : i;
        return version.substring(0, i);
    }

    public static enum BrowserType {
        IE("MSIE", " "),
        FIREFOX("Firefox"),
        OPERA("Opera"),
        CHROME("Chrome"),
        SAFARI("Safari");

        private String m_name = null;
        private String m_versionSeperator = "/";

        private BrowserType(String name, String seperator) {
            this.m_name = name;
            this.m_versionSeperator = seperator;
        }

        private BrowserType(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

