/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.trace;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.resource.checksum.Checksum;
import org.eclipse.vjet.dsf.resource.trace.IResourceUsageTracer;

public class ResourceUsageCtx
extends BaseSubCtx {
    private IResourceUsageTracer m_tracer = IResourceUsageTracer.NULL_TRACER;
    private boolean m_needVerboseInfo = false;
    private boolean m_needObfuscation = false;
    private boolean m_needMinification = false;
    private int m_minificationVersion = 1;
    private boolean m_useOptimizedExternalPaths = false;
    private boolean m_needJsCoverage = false;
    private boolean m_inlineInfo = false;
    private HashSet<String> m_inlinedUrns = new HashSet();
    private boolean m_useVjoBootstrapVariation = false;
    private boolean m_minificationRegistered;
    private boolean m_obfuscationRegistered;
    private boolean m_needCssOptimization = false;
    private boolean m_fragmentExtractionMode = false;
    private HashMap<String, String> m_resourceCache = new HashMap();

    public static ResourceUsageCtx ctx() {
        ResourceUsageCtx context = CtxAssociator.getCtx();
        if (context == null) {
            context = new ResourceUsageCtx();
            ResourceUsageCtx.setCtx(context);
        }
        return context;
    }

    public static ResourceUsageCtx getFromCtx(DsfCtx ctx) {
        ResourceUsageCtx context = CtxAssociator.getCtx(ctx);
        if (context == null) {
            context = new ResourceUsageCtx();
            ResourceUsageCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(ResourceUsageCtx context) {
        CtxAssociator.setCtx(context);
    }

    public void reset() {
        this.m_tracer = IResourceUsageTracer.NULL_TRACER;
        this.m_needVerboseInfo = false;
        this.m_resourceCache = new HashMap();
    }

    public void setTracer(IResourceUsageTracer tracer) {
        this.m_tracer = tracer;
        if (this.m_tracer == null) {
            this.m_tracer = IResourceUsageTracer.NULL_TRACER;
        }
    }

    public IResourceUsageTracer getTracer() {
        return this.m_tracer;
    }

    public boolean isNeedVerboseInfo() {
        return this.m_needVerboseInfo;
    }

    public void setNeedVerboseInfo(boolean set) {
        this.m_needVerboseInfo = set;
    }

    public void setNeedJsCoverage(boolean set) {
        this.m_needJsCoverage = set;
    }

    public boolean isNeedJsCoverage() {
        return this.m_needJsCoverage;
    }

    public boolean isNeedObfuscation() {
        return this.m_needObfuscation;
    }

    public void setNeedObfuscation(boolean set) {
        this.m_needObfuscation = set;
    }

    public boolean isNeedMinification() {
        return this.m_needMinification;
    }

    public void setNeedMinification(boolean set) {
        this.m_needMinification = set;
    }

    public int getMinificationVersion() {
        return this.m_minificationVersion;
    }

    public void setMinificationVersion(int minificationVersion) {
        this.m_minificationVersion = minificationVersion;
    }

    public boolean isUseOptimizedExternalPaths() {
        return this.m_useOptimizedExternalPaths;
    }

    public void setUseOptimizedExternalPaths(boolean useOptimizedExternalPaths) {
        this.m_useOptimizedExternalPaths = useOptimizedExternalPaths;
    }

    public boolean isNeedCssOptimization() {
        return this.m_needCssOptimization;
    }

    public boolean isFragmentExtractionMode() {
        return this.m_fragmentExtractionMode;
    }

    public boolean setFragmentExtractionMode(boolean value) {
        boolean oldValue = this.m_fragmentExtractionMode;
        this.m_fragmentExtractionMode = value;
        return oldValue;
    }

    public void setNeedCssOptimization(boolean set) {
        this.m_needCssOptimization = set;
    }

    public HashSet<String> getInlinedUrns() {
        return this.m_inlinedUrns;
    }

    public void setInlinedUrns(String string) {
        this.m_inlinedUrns.add(string);
    }

    public boolean isNeedinlineInfo() {
        return this.m_inlineInfo;
    }

    public void setNeedinlineInfo(boolean info) {
        this.m_inlineInfo = info;
    }

    public boolean useVjoBootstrapVariation() {
        return this.m_useVjoBootstrapVariation;
    }

    public void setUseVjoBootstrapVariation(boolean bootstrapVariation) {
        this.m_useVjoBootstrapVariation = bootstrapVariation;
    }

    public void registerMinificationEvent() {
        this.m_minificationRegistered = true;
    }

    public void setMinificationEvent(boolean value) {
        this.m_minificationRegistered = value;
    }

    public boolean isMinificationEventDetected() {
        return this.m_minificationRegistered;
    }

    public void registerObfuscationEvent() {
        this.m_obfuscationRegistered = true;
    }

    public void setObfuscationEvent(boolean enable) {
        this.m_obfuscationRegistered = enable;
    }

    public boolean isObfuscationEventDetected() {
        return this.m_obfuscationRegistered;
    }

    public void resetModificationEvents() {
        this.m_minificationRegistered = false;
        this.m_obfuscationRegistered = false;
    }

    public String dedup(String content) {
        if (content == null) {
            return null;
        }
        String hash = Checksum.checksum(content);
        String origContent = this.m_resourceCache.get(hash);
        if (origContent != null) {
            return origContent;
        }
        this.m_resourceCache.put(hash, content);
        return content;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = ResourceUsageCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static ResourceUsageCtx getCtx() {
            return (ResourceUsageCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME));
        }

        protected static void setCtx(ResourceUsageCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }

        protected static ResourceUsageCtx getCtx(DsfCtx ctx) {
            return (ResourceUsageCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)ctx, (String)CTX_NAME));
        }
    }
}

