/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.pattern;

import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.resource.pattern.IResource;

public class BaseResource
implements IResource {
    protected final Class<?> m_anchorClass;
    protected final String m_resourceName;
    protected final String m_urn;

    public BaseResource(Class<?> anchorClass, String resourceName) {
        this(anchorClass, resourceName, null);
    }

    public BaseResource(Class<?> anchorClass, String resourceName, String urn) {
        assert (anchorClass != null) : "anchor class must not be null";
        assert (resourceName != null) : "resourceName must not be null";
        this.m_anchorClass = anchorClass;
        this.m_resourceName = resourceName;
        this.m_urn = urn != null ? urn : String.valueOf(this.m_anchorClass.getName()) + "." + this.m_resourceName;
    }

    protected BaseResource() {
        this.m_anchorClass = null;
        this.m_resourceName = null;
        this.m_urn = null;
    }

    @Override
    public String getUrn() {
        if (this.m_urn == null) {
            DsfExceptionHelper.chuck((String)(String.valueOf(this.m_resourceName) + " urn was not found"));
        }
        return this.m_urn;
    }

    public Class<?> getAnchorClass() {
        return this.m_anchorClass;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public String toString() {
        return this.m_urn;
    }
}

