/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.pattern.js;

import java.net.URL;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.resource.pattern.IResourceRef;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResRtCfg;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;

public final class JsResourceRef
implements IJsResourceRef {
    private final Class<? extends IJsResourceDispenser> m_dispenser;
    private IJsResourceDispenser m_dispenserInstance = null;
    private final JsResource m_resource;
    private final JsType m_type;
    private volatile String m_verboseInfo = null;
    private volatile String m_inlineJsInfo = null;
    private static String NEW_LINE = "\n";

    public boolean isTextadapter() {
        return this.m_resource.isTextOnlyadapter();
    }

    JsResourceRef(JsResource resource, Class<? extends IJsResourceDispenser> dispenser, JsType type) {
        this.m_resource = resource;
        this.m_dispenser = dispenser;
        this.m_type = type;
    }

    public String getUrn() {
        if (this.m_resource == null) {
            DsfExceptionHelper.chuck((String)("resource is empty check dispenser class:" + this.m_dispenser));
        }
        return this.m_resource.getUrn();
    }

    @Override
    public JsType getType() {
        return this.m_type;
    }

    @Override
    public IJsResourceHandle getHandle(Permutation permutationCtx) {
        ResourceUsageCtx ctx = ResourceUsageCtx.ctx();
        ctx.getTracer().accessed((IResourceRef)this);
        IJsResourceHandle handle = this.m_resource.getHandle(permutationCtx);
        if (ctx.isNeedVerboseInfo()) {
            handle = new VerboseJsHandle(handle, this.getVerboseInfo());
        } else if (ctx.isNeedJsCoverage() && JsResRtCfg.getInstance().getJsInstrumentResourceHandle() != null) {
            IJsInstrumentResourceHandle instrumentHandle = JsResRtCfg.getInstance().getJsInstrumentResourceHandle();
            instrumentHandle.setHandle(handle);
            handle = instrumentHandle;
        }
        if (ctx.isNeedinlineInfo() && ctx.getInlinedUrns().contains(this.m_resource.getUrn())) {
            handle = new InLineJsHandle(handle, this.getInlineInfo());
        }
        return handle;
    }

    public Class<? extends IJsResourceDispenser> getDispenser() {
        return this.m_dispenser;
    }

    public IJsResourceDispenser getDispenserInstance() {
        return this.m_dispenserInstance;
    }

    public void setDispenserInstance(IJsResourceDispenser instance) {
        this.m_dispenserInstance = instance;
    }

    @Override
    public JsResource getResource() {
        return this.m_resource;
    }

    public String toString() {
        Z z = new Z();
        z.format("resource", (Object)this.m_resource);
        z.format("dispenser", (Object)this.m_dispenser.getName());
        return z.toString();
    }

    public String getVerboseInfo() {
        if (this.m_verboseInfo == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("/**").append(NEW_LINE).append(" * @Resource ").append(this.m_resource.getUrn()).append(NEW_LINE).append(" * @Dispenser ").append(this.m_dispenser.getName()).append(NEW_LINE).append(" */").append(NEW_LINE);
            this.m_verboseInfo = sb.toString();
        }
        return this.m_verboseInfo;
    }

    public String getInlineInfo() {
        if (this.m_inlineJsInfo == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("/**").append(NEW_LINE).append("* @Inlined").append(NEW_LINE).append(" * @Resource ").append(this.m_resource.getUrn()).append(NEW_LINE).append(" * @Dispenser ").append(this.m_dispenser.getName()).append(NEW_LINE).append(" */").append(NEW_LINE);
            this.m_inlineJsInfo = sb.toString();
        }
        return this.m_inlineJsInfo;
    }

    public static interface IJsInstrumentResourceHandle
    extends IJsResourceHandle {
        public void setHandle(IJsResourceHandle var1);
    }

    private static class InLineJsHandle
    implements IJsResourceHandle {
        private final String m_InlineInfo;
        private final IJsResourceHandle m_handle;

        private InLineJsHandle(IJsResourceHandle handle, String inlineInfo) {
            this.m_InlineInfo = inlineInfo;
            this.m_handle = handle;
        }

        @Override
        public URL getExternalUrl() {
            return this.m_handle.getExternalUrl();
        }

        @Override
        public String getScriptText() {
            return String.valueOf(this.m_InlineInfo) + this.m_handle.getScriptText();
        }

        @Override
        public boolean isExternalized() {
            return this.m_handle.isExternalized();
        }
    }

    private static class VerboseJsHandle
    implements IJsResourceHandle {
        private final String m_verboseInfo;
        private final IJsResourceHandle m_handle;

        private VerboseJsHandle(IJsResourceHandle handle, String verboseInfo) {
            this.m_verboseInfo = verboseInfo;
            this.m_handle = handle;
        }

        @Override
        public URL getExternalUrl() {
            return this.m_handle.getExternalUrl();
        }

        @Override
        public String getScriptText() {
            return String.valueOf(this.m_verboseInfo) + this.m_handle.getScriptText();
        }

        @Override
        public boolean isExternalized() {
            return this.m_handle.isExternalized();
        }
    }
}

