/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref.internals;

import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.IJsVariableBinding;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.DefaultJava2JsConverter;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.EnumJsConverter;
import org.eclipse.vjet.vsf.jsruntime.jsconverters.registry.Java2JsTypeConverterRegistration;

public class JsTypeConvertor {
    public static String toJsArg(IValueBinding<?> value) {
        if (value instanceof IJsVariableBinding) {
            return ((IJsVariableBinding)value).getVariableRef();
        }
        Object realValue = value.getValue();
        if (realValue instanceof IJsVariableBinding) {
            return ((IJsVariableBinding)realValue).getVariableRef();
        }
        return JsTypeConvertor.convertToJsType(realValue);
    }

    static IConverter getDefaultConverter(Object value) {
        Class<?> fromType = null;
        Class<String> toType = String.class;
        Java2JsTypeConverterRegistration registry = JsRuntimeCtx.ctx().getConverterRegistry();
        if (registry == null) {
            JsTypeConvertor.chuck("registry is null");
        }
        try {
            if (value != null) {
                fromType = value.getClass();
            }
            IConverter converter = null;
            while (fromType != null) {
                converter = registry.get(fromType, toType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] clzs = fromType.getInterfaces();
                if (converter == null && clzs != null) {
                    Class<?>[] classArray = clzs;
                    int n = clzs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> clz = classArray[n2];
                        IConverter tmp = registry.get(clz, toType);
                        if (tmp != null) {
                            return tmp;
                        }
                        ++n2;
                    }
                }
                fromType = fromType.getSuperclass();
            }
            if (converter == null) {
                if (value instanceof Enum) {
                    return new EnumJsConverter();
                }
                return new DefaultJava2JsConverter();
            }
            return converter;
        }
        catch (RuntimeException e) {
            throw new DsfRuntimeException("Got exception when looking up the registry: fromType:" + fromType + " toType:" + toType + " value: " + value, (Throwable)e);
        }
    }

    public static String convertToJsType(Object value) {
        IConverter converter = JsTypeConvertor.getDefaultConverter(value);
        IConversionResult result = null;
        if (converter != null) {
            result = converter.convert(value);
        } else {
            converter = new DefaultJava2JsConverter();
            result = converter.convert(value);
        }
        return (String)result.getValue();
    }

    private static void chuck(String string) {
    }
}

