/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref;

import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtxHelper;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.html.js.IJsVariableBinding;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.vsf.jsref.JsObj;
import org.eclipse.vjet.vsf.jsref.internals.Params;
import org.eclipse.vjet.vsf.jsref.util.ActivateJs;

public class JsFunc<T>
implements IValueBinding<T>,
IJsVariableBinding,
IJsFunc {
    private static final long serialVersionUID = 1L;
    private final JsObj m_obj;
    private final String m_name;
    private Params m_params = new Params(new Object[0]);
    private final boolean m_hasReturn;
    private final boolean m_isProp;
    private JsObj m_context;

    public JsFunc(JsObj obj, String name, boolean isProp) {
        this(obj, name, isProp, true);
    }

    public JsFunc(JsObj obj, String name, boolean isProp, boolean hasReturn) {
        this.m_obj = obj;
        this.m_name = name;
        this.m_hasReturn = hasReturn;
        this.m_isProp = isProp;
        this.m_context = null;
    }

    public JsObj getObj() {
        return this.m_obj;
    }

    public String getName() {
        return this.m_name;
    }

    public Params getParams() {
        return this.m_params;
    }

    public JsFunc<T> setParams(Params params) {
        if (params == null) {
            JsFunc.chuck("Params must not be null");
        }
        this.m_params = params;
        return this;
    }

    public String generate() {
        return this.genInvocationJs(this.m_hasReturn);
    }

    public String generate(String scope) {
        return this.genInvocationJs(this.m_hasReturn, scope);
    }

    public T getValue() {
        throw new DsfRuntimeException("Not supported");
    }

    public Class<T> getValueType() {
        throw new DsfRuntimeException("Not supported");
    }

    public void setValue(T value) {
        JsFunc.chuck("Not supported");
    }

    public String getVariableRef() {
        return this.genInvocationJs();
    }

    public String genInvocationJs(boolean includeReturn) {
        if (includeReturn) {
            return "return " + this.genInvocationJs() + ";";
        }
        return String.valueOf(this.genInvocationJs()) + ";";
    }

    private String genInvocationJs(boolean includeReturn, String scope) {
        String rv = "";
        if (includeReturn) {
            rv = String.valueOf(rv) + "return ";
        }
        return String.valueOf(rv) + this.genInvocationJs(scope) + ";";
    }

    private String genInvocationJs(String scope) {
        if (this.isProp()) {
            try {
                DarwinStatisticsCtxHelper.countJsStatistics((String)this.getObj().getCmpMeta().getCmpName());
            }
            catch (Exception ex) {
                Logger.getInstance(JsFunc.class).log(LogLevel.ERROR, (Throwable)ex);
            }
        }
        StringBuilder sb = new StringBuilder(60);
        sb.append(this.genFuncRef(scope));
        if (this.m_context != null) {
            sb.append(".").append("call(").append(this.m_context.generate()).append(",").append(this.m_params).append(")");
        } else {
            sb.append("(").append(this.m_params.genArgs()).append(")");
        }
        return sb.toString();
    }

    private String genFuncRef(String scope) {
        StringBuilder sb = new StringBuilder(60);
        if (scope == null || "".equals(scope)) {
            sb.append(this.getScope());
        } else {
            sb.append(scope);
        }
        sb.append(".").append(this.m_name);
        return sb.toString();
    }

    public String genFuncRef() {
        return this.genFuncRef(null);
    }

    public String genInvocationJs() {
        return this.genInvocationJs(this.getScope());
    }

    public String getScope() {
        if (this.isProp()) {
            return this.m_obj.getCmpMeta().getCmpName();
        }
        return this.m_obj.getRefJs();
    }

    public boolean isProp() {
        return this.m_isProp;
    }

    public JsFunc<T> with(Object ... args) {
        this.m_params = new Params(args);
        return this;
    }

    public void onClient() {
        ActivateJs.now(this);
    }

    private static void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }
}

