/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.event;

import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;

public class DapEvent
extends ActiveObject
implements Event {
    private EventTarget m_target;
    private EventType m_eventType;
    private boolean m_canBubble = false;
    private boolean m_cancelable = false;
    private long m_timestamp = 0L;
    private boolean m_stopPropagation = false;
    private boolean m_stopImmediatePropagation = false;
    private boolean m_preventDefault = false;
    private boolean m_returnValue = true;
    private Object m_view;

    public DapEvent(EventTarget target, EventType eventType) {
        this.m_target = target;
        this.m_eventType = eventType;
        this.popScriptable();
    }

    private void popScriptable() {
        this.populateScriptable(DapEvent.class, DapCtx.ctx().getWindow().getBrowserType());
    }

    public DapEvent() {
        this.popScriptable();
    }

    public EventTarget getTarget() {
        return this.m_target;
    }

    public EventTarget getSrcElement() {
        return this.m_target;
    }

    public String getType() {
        return this.m_eventType == null ? null : this.m_eventType.getName();
    }

    protected void setType(String typeName) {
        EventType type = EventType.get((String)typeName);
        if (type != null) {
            this.m_eventType = type;
        }
    }

    public boolean getBubbles() {
        return this.m_canBubble;
    }

    public boolean getCancelBubble() {
        return !this.m_canBubble;
    }

    public boolean getCancelable() {
        return this.m_cancelable;
    }

    public long getTimeStamp() {
        return this.m_timestamp;
    }

    public void stopPropagation() {
        this.m_stopPropagation = true;
    }

    public void preventDefault() {
        this.m_preventDefault = true;
    }

    public void stopImmediatePropagation() {
        this.m_stopImmediatePropagation = true;
    }

    public boolean getDefaultPrevented() {
        return this.m_preventDefault;
    }

    public boolean getReturnValue() {
        return this.m_returnValue;
    }

    public void setTarget(EventTarget target) {
        this.m_target = target;
    }

    public void setSrcElement(EventTarget target) {
        this.m_target = target;
    }

    public void setCanBubble(boolean bubble) {
        this.m_canBubble = bubble;
    }

    public void setCancelBubble(boolean cancelBubble) {
        this.m_canBubble = !cancelBubble;
    }

    public void setCancelable(boolean cancelable) {
        this.m_cancelable = cancelable;
    }

    public Object getView() {
        return this.m_view;
    }

    public void setView(Object view) {
        this.m_view = view;
    }

    public void setTimestamp(long m_timestamp) {
        this.m_timestamp = m_timestamp;
    }

    public void setEventType(EventType type) {
        this.m_eventType = type;
    }

    public boolean isStopPropagation() {
        return this.m_stopPropagation;
    }

    public boolean isStopImmediatePropagation() {
        return this.m_stopImmediatePropagation;
    }

    public void setReturnValue(boolean value) {
        this.m_returnValue = value;
    }
}

