/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.IDapReplay;
import org.eclipse.vjet.dsf.dap.cnr.ReplaySpeed;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEngine;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.simple.SimpleDLCEventTypes;

public class DapReplay
implements IDapReplay {
    private final DapBrowserEngine m_browserEngine;
    private final IDLCDispatcher m_dlcDispatcher;

    public DapReplay(DapBrowserEngine browserEmulator, IDLCClient dlcClient) {
        this.m_browserEngine = browserEmulator;
        this.m_dlcDispatcher = browserEmulator.getDispatcher();
    }

    @Override
    public void play(DapCaptureData captureData, ReplaySpeed speed) {
        long previousTime = System.currentTimeMillis();
        for (DapCaptureData.IEventCapture capture : captureData.getAllEventCaptures()) {
            if (capture instanceof DapCaptureData.EventCapture) {
                DapCaptureData.EventCapture ec = (DapCaptureData.EventCapture)capture;
                long currentEventTime = System.currentTimeMillis();
                long timeDiff = currentEventTime - previousTime;
                long expectedDiff = ec.getEventTimeInterval() * (long)speed.getFactor();
                long l = expectedDiff = expectedDiff > speed.getMaxWait() ? speed.getMaxWait() : expectedDiff;
                if (expectedDiff > timeDiff) {
                    try {
                        Thread.sleep(expectedDiff - timeDiff);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (ec.getEvent() == null) continue;
                this.synchForRealBrowser(ec.getEvent());
                this.m_browserEngine.onReceive(ec.getEvent());
                previousTime = System.currentTimeMillis();
                continue;
            }
            if (!(capture instanceof DapCaptureData.TaskCapture)) continue;
            DapCaptureData.TaskCapture tc = (DapCaptureData.TaskCapture)capture;
            this.m_browserEngine.executeTask(tc.getInfo());
        }
    }

    private void synchForRealBrowser(DLCEvent event) {
        if (this.m_dlcDispatcher == null) {
            return;
        }
        String eventType = event.getType();
        String msg = event.getPayload();
        int idx = msg.indexOf(":[");
        if (idx > 0) {
            msg = msg.substring(0, idx);
        }
        this.m_dlcDispatcher.send(msg);
        if (SimpleDLCEventTypes.CHANGE.equals(eventType)) {
            this.m_dlcDispatcher.send(msg);
        } else if ("radioChange".equals(eventType)) {
            this.m_dlcDispatcher.send(msg);
        } else if (SimpleDLCEventTypes.KEYUP.equals(eventType)) {
            this.m_dlcDispatcher.send(msg);
        }
    }
}

