/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.util;

import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;

public final class HashtableOfBinding {
    public char[][] keyTable;
    public Binding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfBinding() {
        this(3);
    }

    public HashtableOfBinding(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new char[extraRoom][];
        this.valueTable = new Binding[extraRoom];
    }

    public boolean containsKey(char[] key) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = CharOperation.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                return true;
            }
            if (++index != length) continue;
            index = 0;
        }
        return false;
    }

    public Binding get(char[] key) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = CharOperation.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    public Binding put(char[] key, Binding value) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = CharOperation.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        HashtableOfBinding newHashtable = new HashtableOfBinding(this.elementSize < 100 ? 100 : this.elementSize * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            char[] currentKey = this.keyTable[i];
            if (currentKey == null) continue;
            newHashtable.put(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "";
        int i = 0;
        int length = this.valueTable.length;
        while (i < length) {
            Binding type = this.valueTable[i];
            if (type != null) {
                s = String.valueOf(s) + type.toString() + "\n";
            }
            ++i;
        }
        return s;
    }
}

