/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ClassScope;

public class Javadoc
extends ASTNode
implements IJsDoc {
    public JavadocSingleNameReference[] paramReferences;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;
    public long valuePositions = -1L;
    public int modifiers = 0;
    public TypeReference namespace = null;
    public TypeReference memberOf = null;
    public TypeReference returnType = null;
    public TypeReference extendsType = null;
    public TypeReference classDef = null;
    public TypeReference methodDef = null;
    public JavadocSingleNameReference property = null;
    public boolean isConstructor;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    boolean canBeSeen(int visibility, int modifiers) {
        if (modifiers < 0) {
            return true;
        }
        switch (modifiers & 7) {
            case 1: {
                return true;
            }
            case 4: {
                return visibility != 1;
            }
            case 0: {
                return visibility == 0 || visibility == 2;
            }
            case 2: {
                return visibility == 2;
            }
        }
        return true;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i;
        Javadoc.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            i = 0;
            length = this.paramReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i = 0;
            length = this.exceptionReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.seeReferences != null) {
            i = 0;
            length = this.seeReferences.length;
            while (i < length) {
                Javadoc.printIndent(indent + 1, output).append(" * @see ");
                this.seeReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.returnType != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @type ");
            this.returnType.print(indent, output).append('\n');
        }
        if (this.memberOf != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @member ");
            this.memberOf.print(indent, output).append('\n');
        }
        if (this.extendsType != null) {
            Javadoc.printIndent(indent + 1, output).append(" * @extends ");
            this.extendsType.print(indent, output).append('\n');
        }
        if (this.isConstructor) {
            Javadoc.printIndent(indent + 1, output).append(" * @constructor\n");
        }
        if ((this.modifiers & 2) != 0) {
            Javadoc.printIndent(indent + 1, output).append(" * @private\n");
        }
        if ((this.modifiers & 0x10) != 0) {
            Javadoc.printIndent(indent + 1, output).append(" * @final\n");
        }
        Javadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i;
            if (this.paramReferences != null) {
                i = 0;
                length = this.paramReferences.length;
                while (i < length) {
                    this.paramReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i = 0;
                length = this.exceptionReferences.length;
                while (i < length) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.seeReferences != null) {
                i = 0;
                length = this.seeReferences.length;
                while (i < length) {
                    this.seeReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int length;
            int i;
            if (this.paramReferences != null) {
                i = 0;
                length = this.paramReferences.length;
                while (i < length) {
                    this.paramReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.returnStatement != null) {
                this.returnStatement.traverse(visitor, scope);
            }
            if (this.exceptionReferences != null) {
                i = 0;
                length = this.exceptionReferences.length;
                while (i < length) {
                    this.exceptionReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.seeReferences != null) {
                i = 0;
                length = this.seeReferences.length;
                while (i < length) {
                    this.seeReferences[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public JavadocSingleNameReference findParam(char[] name) {
        if (this.paramReferences != null) {
            int i = 0;
            while (i < this.paramReferences.length) {
                if (CharOperation.equals(name, this.paramReferences[i].token)) {
                    return this.paramReferences[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int getASTType() {
        return 51;
    }
}

