/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IImportReference;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;

public class ImportReference
extends ASTNode
implements IImportReference {
    public char[][] tokens;
    public long[] sourcePositions;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;

    public ImportReference(char[][] tokens, long[] sourcePositions, boolean onDemand) {
        this.tokens = tokens;
        this.sourcePositions = sourcePositions;
        if (onDemand) {
            this.bits |= 0x20000;
        }
        this.sourceEnd = (int)(sourcePositions[sourcePositions.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(sourcePositions[0] >>> 32);
    }

    public ImportReference(char[] name, int startPosition, int endPosition, int nameStartPosition) {
        this.tokens = CharOperation.splitOn('.', name);
        this.sourcePositions = new long[this.tokens.length];
        int i = 0;
        while (i < this.tokens.length) {
            this.sourcePositions[i] = ((long)nameStartPosition << 32) + (long)(nameStartPosition + this.tokens[i].length - 1);
            nameStartPosition += this.tokens[i].length + 1;
            ++i;
        }
        this.bits |= 0x10;
        this.bits |= 0x20000;
        this.declarationSourceStart = this.sourceStart = startPosition;
        this.declarationEnd = this.sourceEnd = endPosition;
        this.declarationSourceEnd = this.sourceEnd;
    }

    public char[][] getImportName() {
        return this.tokens;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        return this.print(indent, output, true);
    }

    public StringBuffer print(int tab, StringBuffer output, boolean withOnDemand) {
        int i = 0;
        while (i < this.tokens.length) {
            if (i > 0) {
                output.append('.');
            }
            output.append(this.tokens[i]);
            ++i;
        }
        if (withOnDemand && (this.bits & 0x20000) != 0) {
            output.append(".*");
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public boolean isInternal() {
        return (this.bits & 0x10) != 0;
    }

    public boolean isFileImport() {
        return (this.bits & 0x10) != 0;
    }
}

