/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.ICombinedBinaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class CombinedBinaryExpression
extends BinaryExpression
implements ICombinedBinaryExpression {
    public int arity;
    public int arityMax;
    public static final int ARITY_MAX_MAX = 160;
    public static final int ARITY_MAX_MIN = 20;
    public static int defaultArityMaxStartingValue = 20;
    public BinaryExpression[] referencesTable;

    public CombinedBinaryExpression(Expression left, Expression right, int operator, int arity) {
        super(left, right, operator);
        this.arity = arity;
        if (arity > 1) {
            this.referencesTable = new BinaryExpression[arity];
            this.referencesTable[arity - 1] = (BinaryExpression)left;
            int i = arity - 1;
            while (i > 0) {
                this.referencesTable[i - 1] = (BinaryExpression)this.referencesTable[i].left;
                --i;
            }
        } else {
            this.arityMax = defaultArityMaxStartingValue;
        }
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        if (this.referencesTable == null) {
            return super.printExpressionNoParenthesis(indent, output);
        }
        String operatorString = this.operatorToString();
        int i = this.arity - 1;
        while (i >= 0) {
            output.append('(');
            --i;
        }
        output = this.referencesTable[0].left.printExpression(indent, output);
        i = 0;
        int end = this.arity;
        while (i < end) {
            output.append(' ').append(operatorString).append(' ');
            output = this.referencesTable[i].right.printExpression(0, output);
            output.append(')');
            ++i;
        }
        output.append(' ').append(operatorString).append(' ');
        return this.right.printExpression(0, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (this.referencesTable == null) {
            super.traverse(visitor, scope);
        } else {
            if (visitor.visit(this, scope)) {
                int restart = this.arity - 1;
                while (restart >= 0) {
                    if (!visitor.visit(this.referencesTable[restart], scope)) {
                        visitor.endVisit(this.referencesTable[restart], scope);
                        break;
                    }
                    --restart;
                }
                if (++restart == 0) {
                    this.referencesTable[0].left.traverse(visitor, scope);
                }
                int i = restart;
                int end = this.arity;
                while (i < end) {
                    this.referencesTable[i].right.traverse(visitor, scope);
                    visitor.endVisit(this.referencesTable[i], scope);
                    ++i;
                }
                this.right.traverse(visitor, scope);
            }
            visitor.endVisit(this, scope);
        }
    }

    public void tuneArityMax() {
        if (this.arityMax < 160) {
            this.arityMax *= 2;
        }
    }

    @Override
    public int getASTType() {
        return 22;
    }
}

