/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.actions.nature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vjet.eclipse.ui.actions.nature.DefaultAddVjoNaturePolicy;
import org.eclipse.vjet.eclipse.ui.actions.nature.IAddVjoNaturePolicy;

public class AddVjoNaturePolicyManager {
    private static final IAddVjoNaturePolicy defaultPolicy = new DefaultAddVjoNaturePolicy();
    private List<IAddVjoNaturePolicy> polices = new ArrayList<IAddVjoNaturePolicy>();
    private static AddVjoNaturePolicyManager instance;
    private static final String EXTENSION_POINT_ID = "org.eclipse.vjet.eclipse.ui.addVjoNaturePolicy";
    private boolean extensionAdded = false;

    private AddVjoNaturePolicyManager() {
    }

    public static AddVjoNaturePolicyManager getInstance() {
        if (instance == null) {
            instance = new AddVjoNaturePolicyManager();
        }
        return instance;
    }

    public IAddVjoNaturePolicy getPolicy(IProject project) {
        if (!this.extensionAdded) {
            this.addExtensions();
        }
        for (IAddVjoNaturePolicy policy : this.polices) {
            if (!policy.accept(project)) continue;
            return policy;
        }
        return defaultPolicy;
    }

    private void addExtensions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < configurationElements.length) {
            try {
                Object instance = configurationElements[i].createExecutableExtension("class");
                if (instance instanceof IAddVjoNaturePolicy) {
                    this.polices.add((IAddVjoNaturePolicy)instance);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        this.extensionAdded = true;
    }
}

