/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.mod.ui.text.completion.FieldProposalInfo;
import org.eclipse.dltk.mod.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.mod.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.mod.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.mod.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.mod.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.core.search.matching.ICategoryRequestor;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoCompletionProposal;
import org.eclipse.vjet.eclipse.ui.text.completion.MethodDeclarationCompletionProposal;
import org.eclipse.vjet.eclipse.ui.text.completion.VjoCompletionProposalLabelProvider;
import org.eclipse.vjet.eclipse.ui.text.completion.VjoOverrideCompletionProposal;
import org.eclipse.vjet.eclipse.ui.text.completion.VjoScriptMethodCompletionProposal;

public abstract class AbstractVjoCompletionProposalCollector
extends ScriptCompletionProposalCollector
implements ICategoryRequestor {
    protected static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};

    public AbstractVjoCompletionProposalCollector(ISourceModule cu) {
        super(cu);
    }

    protected CompletionProposalLabelProvider createLabelProvider() {
        return new VjoCompletionProposalLabelProvider();
    }

    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, String label, String string) {
        return new VjoOverrideCompletionProposal(scriptProject, compilationUnit, name, paramTypes, start, length, label, string);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i) {
        VjoCompletionProposal javaScriptCompletionProposal = new VjoCompletionProposal(completion, replaceStart, length, image, displayString, i);
        return javaScriptCompletionProposal;
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, String displayString, int i, boolean isInDoc) {
        VjoCompletionProposal javaScriptCompletionProposal = new VjoCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
        return javaScriptCompletionProposal;
    }

    protected ScriptContentAssistInvocationContext createScriptContentAssistInvocationContext(ISourceModule sourceModule) {
        return null;
    }

    protected char[] getVarTrigger() {
        return VAR_TRIGGER;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        VjoCompletionProposal vjoCompletionProposal;
        IVjoCompletionData vjoKeyword;
        IScriptCompletionProposal scriptCompletionProposal = super.createScriptCompletionProposal(proposal);
        if (proposal.getKind() == 2 && (vjoKeyword = VjoKeywordFactory.getKeywordByName((String)(vjoCompletionProposal = (VjoCompletionProposal)scriptCompletionProposal).getDisplayString())) != null) {
            vjoCompletionProposal.setCursorPosition(vjoKeyword.getCursorOffsetAfterCompletion());
        }
        if (scriptCompletionProposal instanceof VjoCompletionProposal) {
            VjoCompletionProposal p = (VjoCompletionProposal)scriptCompletionProposal;
            p.setExtraInfo(proposal.extraInfo);
        }
        return scriptCompletionProposal;
    }

    public void accept(CompletionProposal proposal) {
        if (proposal.getKind() == 9) {
            this.acceptPotentialMethodDeclaration(proposal);
        }
        super.accept(proposal);
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        if (this.getSourceModule() == null) {
            return;
        }
        String prefix = String.valueOf(proposal.getName());
        int completionStart = proposal.getReplaceStart();
        int completionEnd = proposal.getReplaceEnd();
        int relevance = this.computeRelevance(proposal);
        try {
            IType type;
            IModelElement element = this.getSourceModule().getElementAt(proposal.getCompletionLocation() + 1);
            if (element != null && (type = (IType)element.getAncestor(7)) != null) {
                MethodDeclarationCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance, this.fSuggestedMethodNames, this.fScriptProposals, this.isStaticBlock(proposal));
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private boolean isStaticBlock(CompletionProposal proposal) {
        boolean isStaticBlock = false;
        if (proposal.extraInfo instanceof Boolean) {
            isStaticBlock = (Boolean)proposal.extraInfo;
        }
        return isStaticBlock;
    }

    protected IScriptCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        VjoScriptMethodCompletionProposal proposal = new VjoScriptMethodCompletionProposal(methodProposal, this.getInvocationContext());
        proposal.setSourceModule(this.getSourceModule());
        this.adaptLength(proposal, methodProposal);
        return proposal;
    }

    protected IScriptCompletionProposal createFieldProposal(CompletionProposal proposal, CompletionContext context) {
        String completion = this.createCompletionString(proposal, context);
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createLabelWithTypeAndDeclaration(proposal);
        Image image = this.getImage(this.getLabelProvider().createFieldImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        ScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo((ProposalInfo)new FieldProposalInfo(this.fScriptProject, proposal));
        }
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }

    private String createCompletionString(CompletionProposal proposal, CompletionContext completionContext) {
        IMember member = (IMember)proposal.getModelElement();
        StringBuffer buffer = new StringBuffer();
        if (CodeassistUtils.isStatic((IMember)member)) {
            buffer.append(CodeassistUtils.getCompletionToken((IMember)member, (ISourceModule)this.getSourceModule()));
        } else if (!(CodeassistUtils.isStatic((IMember)member) || CompletionContext.isInstanceContext() || AbstractVjoCompletionProposalCollector.isNativeObject(member))) {
            buffer.append("this.");
        }
        buffer.append(proposal.getCompletion());
        return buffer.toString();
    }

    private static boolean isNativeObject(IMember member) {
        return member.getAncestor(5) instanceof NativeVjoSourceModule;
    }

    protected int computeRelevance(CompletionProposal proposal) {
        int baseRelevance = CodeassistUtils.getRelevance((CompletionProposal)proposal);
        switch (proposal.getKind()) {
            case 3: {
                return baseRelevance + 0;
            }
            case 2: {
                return baseRelevance + 1;
            }
            case 11: {
                return baseRelevance + 2;
            }
            case 7: {
                return baseRelevance + 3;
            }
            case 5: 
            case 6: 
            case 10: {
                return baseRelevance + 4;
            }
            case 9: {
                return baseRelevance + 4;
            }
            case 1: {
                return baseRelevance + 5;
            }
            case 4: 
            case 8: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    public String computeReplacementString(CompletionProposal proposal) {
        IModelElement element = proposal.getModelElement();
        if (element instanceof JSSourceField) {
            JSSourceField method = (JSSourceField)element;
            StringBuffer buffer = new StringBuffer();
            if (CodeassistUtils.isStatic((IMember)method)) {
                buffer.append(CodeassistUtils.getCompletionToken((IMember)method, (ISourceModule)method.getSourceModule()));
            } else if (!(CodeassistUtils.isStatic((IMember)method) || CompletionContext.isInstanceContext() || AbstractVjoCompletionProposalCollector.isNativeObject((IMember)method))) {
                buffer.append("this.");
            }
            return buffer.append(proposal.getCompletion()).toString();
        }
        return String.valueOf(proposal.getCompletion());
    }

    protected IScriptCompletionProposal createFieldProposal(CompletionProposal proposal) {
        String completion = this.computeReplacementString(proposal);
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createLabelWithTypeAndDeclaration(proposal);
        Image image = this.getImage(this.getLabelProvider().createFieldImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        ScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo((ProposalInfo)new FieldProposalInfo(this.fScriptProject, proposal));
        }
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }
}

