/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.nodeprinter.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;

public class BeanStyleNodePrinter
implements INodePrinter {
    @Override
    public String[] getPropertyNames(Object node) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("object_id");
        try {
            Class<?> nodeClass = node.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(nodeClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                propertyNames.add(propertyDescriptors[i].getName());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    @Override
    public Object[] getPropertyValuies(Object node) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        propertyValues.add(node.hashCode());
        try {
            Class<?> nodeClass = node.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(nodeClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                if (propertyDescriptors[i].getReadMethod() != null) {
                    try {
                        Object value = propertyDescriptors[i].getReadMethod().invoke(node, new Object[0]);
                        propertyValues.add(value);
                    }
                    catch (Exception exception) {
                        propertyValues.add(null);
                    }
                } else {
                    propertyValues.add(null);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertyValues.toArray();
    }
}

