/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditorMessages;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.SemanticToken;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlighting;

public class VjoSemanticHighlightings {
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    private static VjoSemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(VjoSemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static VjoSemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new VjoSemanticHighlighting[]{new MethodDeclarationHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        VjoSemanticHighlighting[] semanticHighlightings = VjoSemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            VjoSemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            VjoSemanticHighlightings.setDefaultAndFireEvent(store, VjoSemanticHighlightings.getColorPreferenceKey(semanticHighlighting), semanticHighlighting.getDefaultTextColor());
            store.setDefault(VjoSemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(VjoSemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(VjoSemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(VjoSemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            store.setDefault(VjoSemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++i;
        }
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        VjoSemanticHighlighting[] highlightings = VjoSemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(VjoSemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = VjoSemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        VjoSemanticHighlighting[] highlightings = VjoSemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = VjoSemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore store, String key, RGB newValue) {
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private VjoSemanticHighlightings() {
    }

    private static final class MethodDeclarationHighlighting
    extends VjoSemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return VjoSemanticHighlightings.METHOD_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return VjoEditorMessages.SemanticHighlighting_methodDeclaration;
        }

        public boolean isSemanticOnly() {
            return true;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return token.getMethod() instanceof JstMethod;
        }
    }
}

