/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.dbgp.DbgpURIUtil;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.debug.core.model.IScriptValue;
import org.eclipse.dltk.mod.debug.core.model.IScriptVariable;
import org.eclipse.dltk.mod.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.mod.debug.ui.Messages;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugImageDescriptor;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.mod.internal.debug.ui.ExternalFileEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.VjetDebugPlugin;
import org.eclipse.vjet.eclipse.internal.debug.ui.DBGPScriptCacheManager;
import org.eclipse.vjet.eclipse.internal.launching.LauncherUtil;
import org.eclipse.vjet.eclipse.internal.launching.VjetSourceLookupParticipant;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceModule;

public class VjetDebugModelPresentation
extends ScriptDebugModelPresentation {
    private static final String VJET_EDITOR_ID = "org.eclipse.vjet.ui.VjetJsEditor";
    static ImageRegistry registry = new ImageRegistry(Display.getDefault());
    private DBGPScriptCacheManager m_cacheManager = DBGPScriptCacheManager.getDefault();

    static {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DLTKPluginImages.get((String)"IMG_OBJS_CONTENDED_MONITOR");
            }
        });
    }

    protected final String getStackFrameText(IScriptStackFrame stackFrame) {
        URI sourceURI = stackFrame.getSourceURI();
        if ("dbgp".equals(sourceURI.getScheme())) {
            try {
                return NLS.bind((String)Messages.ScriptDebugModelPresentation_stackFrameText3, (Object)VjetDebugModelPresentation.toString((URI)sourceURI), (Object)new Integer(stackFrame.getLineNumber()));
            }
            catch (DebugException e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
        }
        return super.getStackFrameText(stackFrame);
    }

    protected Image getBreakpointImage(IScriptBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptWatchpoint) {
            IScriptWatchpoint w = (IScriptWatchpoint)breakpoint;
            try {
                if (w.isEnabled()) {
                    return DebugUITools.getImage((String)"IMG_OBJS_WATCHPOINT");
                }
            }
            catch (CoreException e) {
                DLTKDebugPlugin.log((Throwable)e);
            }
            return DebugUITools.getImage((String)"IMG_OBJS_WATCHPOINT_DISABLED");
        }
        if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
            IScriptMethodEntryBreakpoint ll = (IScriptMethodEntryBreakpoint)breakpoint;
            int flags = 0;
            try {
                if (ll.breakOnEntry()) {
                    flags |= 8;
                }
                if (ll.breakOnExit()) {
                    flags |= 0x10;
                }
                if (flags == 0) {
                    return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
                }
                if (ll.isEnabled()) {
                    String key = String.valueOf(flags) + "enabled";
                    Image image = registry.get(key);
                    if (image == null) {
                        registry.put(key, (ImageDescriptor)new ScriptDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags));
                        return registry.get(key);
                    }
                    return image;
                }
                String key = String.valueOf(flags) + "disabled";
                Image image = registry.get(key);
                if (image == null) {
                    registry.put(key, (ImageDescriptor)new ScriptDebugImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags));
                    return registry.get(key);
                }
                return image;
            }
            catch (CoreException e) {
                DLTKDebugPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    protected Image getVariableImage(IScriptVariable variable) {
        IScriptValue scriptValue;
        IScriptVariable v = variable;
        try {
            scriptValue = (IScriptValue)v.getValue();
        }
        catch (DebugException debugException) {
            return ScriptDebugImages.get((String)"IMG_OBJS_LOCAL_VARIABLE");
        }
        String typeString = scriptValue.getType().getName();
        if (typeString.equals("function")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpri_obj.gif");
        }
        if (typeString.equals("javaclass")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.class_obj.gif");
        }
        if (typeString.equals("javaobject")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpro_obj.gif");
        }
        if (typeString.equals("javaarray")) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methdef_obj.gif");
        }
        String fullName = scriptValue.getEvalName();
        if (fullName != null && (fullName.indexOf(46) >= 0 || fullName.equals("this"))) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpub_obj.gif");
        }
        return ScriptDebugImages.get((String)"IMG_OBJS_LOCAL_VARIABLE");
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (CodeassistUtils.isVjetFileName((String)input.getName())) {
            return VJET_EDITOR_ID;
        }
        if (input instanceof IFileEditorInput) {
            return IDE.getDefaultEditor((IFile)((IFileEditorInput)input).getFile()).getId();
        }
        return VJET_EDITOR_ID;
    }

    public IEditorInput getEditorInput(Object element) {
        IEditorInput editorInput = super.getEditorInput(element);
        if (editorInput != null) {
            return editorInput;
        }
        if (element instanceof ILineBreakpoint) {
            editorInput = this.getLineBreakpointEditorInput((ILineBreakpoint)element);
        }
        return editorInput;
    }

    private IEditorInput getLineBreakpointEditorInput(ILineBreakpoint lineBreakpoint) {
        if (this.m_cacheManager.contains((IBreakpoint)lineBreakpoint)) {
            return new ExternalStorageEditorInput(this.m_cacheManager.get((IBreakpoint)lineBreakpoint));
        }
        IMarker marker = lineBreakpoint.getMarker();
        if (marker == null) {
            return null;
        }
        String location = null;
        try {
            location = (String)marker.getAttribute("location");
        }
        catch (CoreException e) {
            VjetDebugPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (location == null) {
            return null;
        }
        IPath path = Path.fromPortableString((String)location);
        if (EnvironmentPathUtils.isFull((IPath)path)) {
            path = EnvironmentPathUtils.getLocalPath((IPath)path);
        }
        ZipEntryStorage storage = null;
        if (this.isZipFile(path)) {
            try {
                storage = LauncherUtil.createZipEntryFile((URI)new URI(path.toString()));
            }
            catch (Exception e) {
                VjetDebugPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (DbgpURIUtil.isDBGPPath((IPath)path)) {
            ILaunch[] launches;
            ILaunch[] iLaunchArray = launches = this.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                ISourceLookupDirector sourceLookupDirector = this.getSourceLookupDirector(launch);
                if (sourceLookupDirector != null) {
                    try {
                        IScriptThread scriptThread;
                        Object sourceElement = sourceLookupDirector.getSourceElement((Object)DbgpURIUtil.convert2DBGPURIFromPath((IPath)path));
                        VjoDBGPSourceModule vjoDBGPSourceModule = null;
                        if (sourceElement instanceof IAdaptable) {
                            vjoDBGPSourceModule = (VjoDBGPSourceModule)((IAdaptable)sourceElement).getAdapter(VjoDBGPSourceModule.class);
                        }
                        if (vjoDBGPSourceModule != null && (scriptThread = this.getFirstScriptThread(launch)) != null && !scriptThread.isTerminated()) {
                            vjoDBGPSourceModule.setDBGPSession(scriptThread.getDbgpSession());
                            this.m_cacheManager.add((IBreakpoint)lineBreakpoint, (IStorage)vjoDBGPSourceModule);
                            storage = vjoDBGPSourceModule;
                            break;
                        }
                    }
                    catch (Exception e) {
                        VjetDebugPlugin.error((String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++n2;
            }
            if (storage == null) {
                throw new UnsupportedOperationException("No cached contents for vjo debugger's virtual file: " + path.toString());
            }
        } else if (this.isLocalFile(path)) {
            Object element = VjetSourceLookupParticipant.findFileElement((String)URI.create(path.toString()).getPath().substring(1));
            if (element instanceof IFile) {
                return new FileEditorInput((IFile)element);
            }
            if (element instanceof IFileHandle) {
                return new ExternalFileEditorInput((IFileHandle)element);
            }
        }
        if (storage != null) {
            return new ExternalStorageEditorInput((IStorage)storage);
        }
        return null;
    }

    private boolean isLocalFile(IPath path) {
        return path.toString().startsWith("file");
    }

    private ISourceLookupDirector getSourceLookupDirector(ILaunch launch) {
        ISourceLookupDirector sourceLookupDirector = null;
        ISourceLocator sourceLocator = launch.getSourceLocator();
        if (sourceLocator != null && sourceLocator instanceof ISourceLookupDirector) {
            sourceLookupDirector = (ISourceLookupDirector)sourceLocator;
        }
        return sourceLookupDirector;
    }

    private ILaunch[] getLaunches() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunches();
    }

    private IScriptThread getFirstScriptThread(ILaunch launch) throws DebugException {
        IScriptThread scriptThread = null;
        IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            IThread[] iThreadArray = debugTarget.getThreads();
            int n3 = iThreadArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IThread thread = iThreadArray[n4];
                if (thread instanceof IScriptThread) {
                    scriptThread = (IScriptThread)thread;
                }
                ++n4;
            }
            ++n2;
        }
        return scriptThread;
    }

    private boolean isZipFile(IPath path) {
        String fileLocation = path.toString();
        return fileLocation.startsWith("jar") || fileLocation.startsWith("zip");
    }
}

