/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.browsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.IElementChangedListener;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.browsing.LogicalPackage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

abstract class LogicalPackagesProvider
implements IPropertyChangeListener,
IElementChangedListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected Map fMapToLogicalPackage;
    protected Map fMapToPackageFragments;
    protected boolean fCompoundState;
    protected StructuredViewer fViewer;
    protected boolean fInputIsProject;

    public LogicalPackagesProvider(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fCompoundState = this.isInCompoundState();
        this.fInputIsProject = true;
        this.fMapToLogicalPackage = new HashMap();
        this.fMapToPackageFragments = new HashMap();
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void addFragmentsToMap(IScriptFolder[] packageFragments) {
        int i = 0;
        while (i < packageFragments.length) {
            IScriptFolder fragment = packageFragments[i];
            String key = this.getKey(fragment);
            this.fMapToPackageFragments.put(key, fragment);
            ++i;
        }
    }

    protected String getKey(IScriptFolder fragment) {
        return String.valueOf(fragment.getElementName()) + fragment.getScriptProject().getElementName();
    }

    public LogicalPackage findLogicalPackage(IScriptFolder fragment) {
        Assert.isNotNull((Object)fragment);
        if (this.isInCompoundState()) {
            return (LogicalPackage)((Object)this.fMapToLogicalPackage.get(this.getKey(fragment)));
        }
        return null;
    }

    protected Object[] combineSamePackagesIntoLogialPackages(IScriptFolder[] packageFragments) {
        if (!this.fCompoundState) {
            return packageFragments;
        }
        ArrayList<LogicalPackage> newChildren = new ArrayList<LogicalPackage>();
        int i = 0;
        while (i < packageFragments.length) {
            IScriptFolder fragment = packageFragments[i];
            if (fragment != null) {
                LogicalPackage lp = this.findLogicalPackage(fragment);
                if (lp != null) {
                    if (lp.belongs(fragment)) {
                        lp.add(fragment);
                    }
                    if (!newChildren.contains((Object)lp)) {
                        newChildren.add(lp);
                    }
                } else {
                    String key = this.getKey(fragment);
                    IScriptFolder frag = (IScriptFolder)this.fMapToPackageFragments.get(key);
                    if (frag != null && !fragment.equals(frag)) {
                        lp = new LogicalPackage(frag);
                        lp.add(fragment);
                        newChildren.remove(frag);
                        newChildren.add(lp);
                        this.fMapToLogicalPackage.put(key, lp);
                        this.fMapToPackageFragments.remove(frag);
                    } else {
                        this.fMapToPackageFragments.put(key, fragment);
                        newChildren.add((LogicalPackage)fragment);
                    }
                }
            }
            ++i;
        }
        return newChildren.toArray();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fCompoundState == this.isInCompoundState()) {
            return;
        }
        this.fCompoundState = this.isInCompoundState();
        if (!this.isInCompoundState()) {
            this.fMapToLogicalPackage.clear();
            this.fMapToPackageFragments.clear();
        }
        if (this.fViewer instanceof TreeViewer) {
            TreeViewer viewer = (TreeViewer)this.fViewer;
            Object[] expandedObjects = viewer.getExpandedElements();
            viewer.refresh();
            viewer.setExpandedElements(expandedObjects);
        } else {
            this.fViewer.refresh();
        }
    }

    protected boolean isInCompoundState() {
        return true;
    }

    public void dispose() {
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fMapToLogicalPackage = null;
        this.fMapToPackageFragments = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            DLTKCore.addElementChangedListener((IElementChangedListener)this);
        } else {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInputIsProject = newInput instanceof IScriptProject;
        if (viewer instanceof StructuredViewer) {
            this.fViewer = (StructuredViewer)viewer;
        }
    }

    protected abstract void processDelta(IModelElementDelta var1) throws ModelException;

    protected boolean isClassPathChange(IModelElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
    }
}

