/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.dialogs.OpenTypeSelectionDialog2;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenTypeAction() {
        this.setText(DLTKUIMessages.OpenTypeAction_label);
        this.setDescription(DLTKUIMessages.OpenTypeAction_description);
        this.setToolTipText(DLTKUIMessages.OpenTypeAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_TOOL_OPENTYPE);
    }

    protected abstract IDLTKUILanguageToolkit getUILanguageToolkit();

    public void run() {
        Shell parent = DLTKUIPlugin.getActiveWorkbenchShell();
        OpenTypeSelectionDialog2 dialog = new OpenTypeSelectionDialog2(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0, this.getUILanguageToolkit());
        dialog.setTitle(this.getOpenTypeDialogTitle());
        dialog.setMessage(this.getOpenTypeDialogMessage());
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IModelElement type = null;
            int i = 0;
            while (i < types.length) {
                type = (IModelElement)types[i];
                try {
                    DLTKUIPlugin.openInEditor(type, true, true);
                }
                catch (CoreException x) {
                    ExceptionHandler.handle(x, this.getOpenTypeErrorTitle(), this.getOpenTypeErrorMessage());
                }
                ++i;
            }
        }
    }

    protected String getOpenTypeErrorMessage() {
        return DLTKUIMessages.OpenTypeAction_errorMessage;
    }

    protected String getOpenTypeErrorTitle() {
        return DLTKUIMessages.OpenTypeAction_errorTitle;
    }

    protected String getOpenTypeDialogMessage() {
        return DLTKUIMessages.OpenTypeAction_dialogMessage;
    }

    protected String getOpenTypeDialogTitle() {
        return DLTKUIMessages.OpenTypeAction_dialogTitle;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

