/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.AccessRuleEntryDialog;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.AccessRulesLabelProvider;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class AccessRulesDialog
extends StatusDialog {
    public static final int SWITCH_PAGE = 10;
    private final ListDialogField fAccessRulesList;
    private final SelectionButtonDialogField fCombineRulesCheckbox;
    private final BPListElement fCurrElement;
    private final IScriptProject fProject;
    private final boolean fParentCanSwitchPage;
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_UP = 3;
    private static final int IDX_DOWN = 4;
    private static final int IDX_REMOVE = 6;

    public AccessRulesDialog(Shell parent, BPListElement entryToEdit, IScriptProject project, boolean parentCanSwitchPage) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fCurrElement = entryToEdit;
        this.fProject = project;
        this.setTitle(NewWizardMessages.AccessRulesDialog_title);
        this.fAccessRulesList = this.createListContents(entryToEdit);
        this.fCombineRulesCheckbox = new SelectionButtonDialogField(32);
        this.fCombineRulesCheckbox.setLabelText(NewWizardMessages.AccessRulesDialog_combine_label);
        this.fCombineRulesCheckbox.setSelection(Boolean.TRUE.equals(entryToEdit.getAttribute("combineaccessrules")));
        this.fParentCanSwitchPage = parentCanSwitchPage;
    }

    private ListDialogField createListContents(BPListElement entryToEdit) {
        String label = NewWizardMessages.AccessRulesDialog_rules_label;
        String[] stringArray = new String[7];
        stringArray[0] = NewWizardMessages.AccessRulesDialog_rules_add;
        stringArray[1] = NewWizardMessages.AccessRulesDialog_rules_edit;
        stringArray[3] = NewWizardMessages.AccessRulesDialog_rules_up;
        stringArray[4] = NewWizardMessages.AccessRulesDialog_rules_down;
        stringArray[6] = NewWizardMessages.AccessRulesDialog_rules_remove;
        String[] buttonLabels = stringArray;
        TypeRestrictionAdapter adapter = new TypeRestrictionAdapter();
        AccessRulesLabelProvider labelProvider = new AccessRulesLabelProvider();
        ListDialogField patternList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        patternList.setDialogFieldListener(adapter);
        patternList.setLabelText(label);
        patternList.setRemoveButtonIndex(6);
        patternList.setUpButtonIndex(3);
        patternList.setDownButtonIndex(4);
        patternList.enableButton(1, false);
        IAccessRule[] rules = (IAccessRule[])entryToEdit.getAttribute("accessrules");
        ArrayList<IAccessRule> elements = new ArrayList<IAccessRule>(rules.length);
        int i = 0;
        while (i < rules.length) {
            elements.add(rules[i]);
            ++i;
        }
        patternList.setElements(elements);
        patternList.selectFirstElement();
        return patternList;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite;
        block15: {
            composite = (Composite)super.createDialogArea(parent);
            int maxLabelSize = 0;
            GC gc = new GC((Drawable)composite);
            try {
                int len3;
                maxLabelSize = gc.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)0)).x;
                int len2 = gc.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)2)).x;
                if (len2 > maxLabelSize) {
                    maxLabelSize = len2;
                }
                if ((len3 = gc.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)1)).x) > maxLabelSize) {
                    maxLabelSize = len3;
                }
            }
            finally {
                gc.dispose();
            }
            ColumnLayoutData[] columnDta = new ColumnLayoutData[]{new ColumnPixelData(maxLabelSize + 40), new ColumnWeightData(1)};
            this.fAccessRulesList.setTableColumns(new ListDialogField.ColumnsDescription(columnDta, null, false));
            Composite inner = new Composite(composite, 0);
            inner.setFont(composite.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            inner.setLayoutData((Object)new GridData(1808));
            Label description = new Label(inner, 64);
            description.setText(this.getDescriptionString());
            GridData data = new GridData(4, 0x1000000, false, false, 2, 1);
            data.widthHint = this.convertWidthInCharsToPixels(70);
            description.setLayoutData((Object)data);
            this.fAccessRulesList.doFillIntoGrid(inner, 3);
            LayoutUtil.setHorizontalSpan((Control)this.fAccessRulesList.getLabelControl(null), 2);
            data = (GridData)this.fAccessRulesList.getListControl(null).getLayoutData();
            data.grabExcessHorizontalSpace = true;
            data.heightHint = -1;
            if (this.fCurrElement.getEntryKind() == 2) {
                this.fCombineRulesCheckbox.doFillIntoGrid(inner, 2);
            }
            if (this.fProject != null) {
                String forbiddenSeverity = this.fProject.getOption("org.eclipse.dltk.mod.core.compiler.problem.forbiddenReference", true);
                String discouragedSeverity = this.fProject.getOption("org.eclipse.dltk.mod.core.compiler.problem.discouragedReference", true);
                Object[] args = new String[]{this.getLocalizedString(discouragedSeverity), this.getLocalizedString(forbiddenSeverity)};
                FormToolkit toolkit = new FormToolkit(parent.getDisplay());
                toolkit.setBackground(null);
                try {
                    try {
                        FormText text = toolkit.createFormText(composite, true);
                        text.setFont(inner.getFont());
                        if (this.fParentCanSwitchPage) {
                            text.setText(Messages.format(NewWizardMessages.AccessRulesDialog_severity_info_with_link, args), true, false);
                            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                                public void linkActivated(HyperlinkEvent e) {
                                    AccessRulesDialog.this.doErrorWarningLinkPressed();
                                }
                            });
                        } else {
                            text.setText(Messages.format(NewWizardMessages.AccessRulesDialog_severity_info_no_link, args), true, false);
                        }
                        data = new GridData(4, 0x1000000, false, false, 2, 1);
                        data.widthHint = this.convertWidthInCharsToPixels(70);
                        text.setLayoutData((Object)data);
                    }
                    catch (IllegalArgumentException e) {
                        DLTKUIPlugin.log(e);
                        toolkit.dispose();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    toolkit.dispose();
                    throw throwable;
                }
                toolkit.dispose();
            }
        }
        AccessRulesDialog.applyDialogFont((Control)composite);
        return composite;
    }

    final void doErrorWarningLinkPressed() {
        if (this.fParentCanSwitchPage && MessageDialog.openQuestion((Shell)this.getShell(), (String)NewWizardMessages.AccessRulesDialog_switch_dialog_title, (String)NewWizardMessages.AccessRulesDialog_switch_dialog_message)) {
            this.setReturnCode(10);
            this.close();
        }
    }

    private String getLocalizedString(String severity) {
        if ("error".equals(severity)) {
            return NewWizardMessages.AccessRulesDialog_severity_error;
        }
        if ("warning".equals(severity)) {
            return NewWizardMessages.AccessRulesDialog_severity_warning;
        }
        return NewWizardMessages.AccessRulesDialog_severity_ignore;
    }

    private String getDescriptionString() {
        String desc;
        String name = this.fCurrElement.getPath().lastSegment();
        if (name.startsWith("#special#builtin#")) {
            name = "(builtins)";
        }
        switch (this.fCurrElement.getEntryKind()) {
            case 5: {
                try {
                    name = ScriptElementLabels.getDefault().getContainerEntryLabel(this.fCurrElement.getPath(), this.fCurrElement.getScriptProject());
                }
                catch (ModelException modelException) {}
                desc = NewWizardMessages.AccessRulesDialog_container_description;
                break;
            }
            case 2: {
                desc = NewWizardMessages.AccessRulesDialog_project_description;
                break;
            }
            default: {
                desc = NewWizardMessages.AccessRulesDialog_description;
            }
        }
        return Messages.format(desc, name);
    }

    protected void doCustomButtonPressed(ListDialogField field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 1) {
            this.editEntry(field);
        }
    }

    protected void doDoubleClicked(ListDialogField field) {
        this.editEntry(field);
    }

    protected void doSelectionChanged(ListDialogField field) {
        List selected = field.getSelectedElements();
        field.enableButton(1, this.canEdit(selected));
    }

    private boolean canEdit(List selected) {
        return selected.size() == 1;
    }

    private void editEntry(ListDialogField field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        IAccessRule rule = (IAccessRule)selElements.get(0);
        AccessRuleEntryDialog dialog = new AccessRuleEntryDialog(this.getShell(), rule, this.fCurrElement);
        if (dialog.open() == 0) {
            field.replaceElement(rule, dialog.getRule());
        }
    }

    private void addEntry(ListDialogField field) {
        AccessRuleEntryDialog dialog = new AccessRuleEntryDialog(this.getShell(), null, this.fCurrElement);
        if (dialog.open() == 0) {
            field.addElement(dialog.getRule());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    public IAccessRule[] getAccessRules() {
        List elements = this.fAccessRulesList.getElements();
        return elements.toArray(new IAccessRule[elements.size()]);
    }

    public boolean doCombineAccessRules() {
        return this.fCombineRulesCheckbox.isSelected();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: AccessRulesDialog add help context");
        }
    }

    public void performPageSwitch(IWorkbenchPreferenceContainer pageContainer) {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO:AccessRulesDialog:");
        }
    }

    private class TypeRestrictionAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TypeRestrictionAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            AccessRulesDialog.this.doCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            AccessRulesDialog.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            AccessRulesDialog.this.doDoubleClicked(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

