/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.ICodeAssist;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.mod.ui.actions.OpenAction;
import org.eclipse.dltk.mod.ui.infoviews.ModelElementArray;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ModelElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public ModelElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion wordRegion;
        ISourceModule input;
        OpenAction openAction;
        block7: {
            if (region == null || !(this.fTextEditor instanceof ScriptEditor)) {
                return null;
            }
            IAction action = this.fTextEditor.getAction("OpenEditor");
            if (action == null || !(action instanceof OpenAction)) {
                return null;
            }
            openAction = (OpenAction)action;
            int offset = region.getOffset();
            input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fTextEditor, false);
            if (input == null) {
                return null;
            }
            try {
                IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
                wordRegion = ScriptWordFinder.findWord(document, offset);
                if (wordRegion != null) break block7;
                return null;
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        IModelElement[] elements = null;
        elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
        if (elements != null && elements.length > 0) {
            ModelElementHyperlink link = elements.length == 1 ? new ModelElementHyperlink(wordRegion, elements[0], openAction) : new ModelElementHyperlink(wordRegion, new ModelElementArray(elements), openAction);
            return new IHyperlink[]{link};
        }
        return null;
    }
}

