/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.vjet;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.vjet.AbstractVjoRenameRefactoringContribution;
import org.eclipse.dltk.mod.internal.corext.refactoring.vjet.descriptors.RenameModelElementDescriptor;
import org.eclipse.dltk.mod.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.dltk.mod.internal.ui.refactoring.reorg.RenameUserInterfaceStarter;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Shell;

public class VjetRenameHelper {
    private static String getContributionId(IModelElement modelElement) {
        String contributionId;
        int elementType = modelElement.getElementType();
        switch (elementType) {
            case 4: {
                contributionId = "org.eclipse.vjet.eclipse.ui.rename.scriptfolder";
                break;
            }
            case 5: {
                contributionId = "org.eclipse.vjet.eclipse.ui.rename.sourcemodule";
                break;
            }
            case 7: {
                contributionId = "org.eclipse.vjet.eclipse.ui.rename.type";
                break;
            }
            default: {
                return null;
            }
        }
        return contributionId;
    }

    private static RenameModelElementDescriptor createVjoRenameDescriptor(IModelElement modelElement, String newName) throws ModelException {
        IDialogSettings dltkSettings;
        IDialogSettings refactoringSettings;
        String contributionId = VjetRenameHelper.getContributionId(modelElement);
        int elementType = modelElement.getElementType();
        RenameModelElementDescriptor descriptor = (RenameModelElementDescriptor)RefactoringCore.getRefactoringContribution((String)contributionId).createDescriptor();
        descriptor.setModelElement(modelElement);
        if (elementType != 4) {
            descriptor.setUpdateReferences(true);
        }
        if ((refactoringSettings = (dltkSettings = DLTKUIPlugin.getDefault().getDialogSettings()).getSection("org.eclipse.ltk.ui.refactoring.settings")) == null) {
            refactoringSettings = dltkSettings.addNewSection("org.eclipse.ltk.ui.refactoring.settings");
        }
        switch (elementType) {
            case 7: {
                int strategy;
                descriptor.setUpdateSimilarDeclarations(refactoringSettings.getBoolean("updateSimilarElements"));
                try {
                    strategy = refactoringSettings.getInt("updateSimilarElementsMatchStrategy");
                }
                catch (NumberFormatException numberFormatException) {
                    strategy = 1;
                }
                descriptor.setMatchStrategy(strategy);
            }
        }
        switch (elementType) {
            case 4: {
                descriptor.setUpdateHierarchy(refactoringSettings.getBoolean("renameSubpackages"));
            }
        }
        switch (elementType) {
            case 4: 
            case 7: {
                String fileNamePatterns = refactoringSettings.get("patterns");
                if (fileNamePatterns == null || fileNamePatterns.length() == 0) break;
                descriptor.setFileNamePatterns(fileNamePatterns);
                boolean updateQualifiedNames = refactoringSettings.getBoolean("updateQualifiedNames");
                descriptor.setUpdateQualifiedNames(updateQualifiedNames);
            }
        }
        switch (elementType) {
            case 4: 
            case 7: 
            case 8: {
                boolean updateTextualOccurrences = refactoringSettings.getBoolean("updateTextualMatches");
                descriptor.setUpdateTextualOccurrences(updateTextualOccurrences);
            }
        }
        return descriptor;
    }

    public static boolean startRenameModelElement(Shell parent, IModelElement modelElement, String newName) throws ModelException, CoreException {
        if (VjetRenameHelper.isRenameAvailable(modelElement)) {
            RenameModelElementDescriptor renameModelElementDescriptor = VjetRenameHelper.createVjoRenameDescriptor(modelElement, newName);
            VjetRenameHelper.openDialog(parent, renameModelElementDescriptor, VjetRenameHelper.getContributionId(modelElement));
            return true;
        }
        return false;
    }

    private static void openDialog(Shell parent, RenameModelElementDescriptor descriptor, String contributionId) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        RenameUserInterfaceStarter starter = new RenameUserInterfaceStarter();
        AbstractVjoRenameRefactoringContribution contribution = (AbstractVjoRenameRefactoringContribution)RefactoringCore.getRefactoringContribution((String)contributionId);
        starter.initialize(contribution.getRenameWizard());
        RenameRefactoring renameRefactoring = (RenameRefactoring)descriptor.createRefactoring(refactoringStatus);
        ((UserInterfaceStarter)starter).activate((Refactoring)renameRefactoring, parent, ((ScriptRenameProcessor)renameRefactoring.getProcessor()).needsSavedEditors());
    }

    private static boolean isRenameAvailable(IModelElement modelElement) {
        if (modelElement instanceof IType) {
            return true;
        }
        if (modelElement instanceof ISourceModule) {
            return true;
        }
        return modelElement instanceof IScriptFolder;
    }
}

