/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.mod.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.mod.internal.debug.core.model.operations.DbgpDebugger;

public class NewScriptThreadManager
implements IScriptThreadManager {
    private static final int WAITING = 0;
    private static final int ACCEPTING = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    private final ListenerList listeners = new ListenerList(1);
    private Object lock = new Object();
    private int state;
    private ScriptThread[] threads;
    private IScriptDebugTarget debugTarget;

    private void destroy() {
        this.state = 3;
    }

    private void addThread(ScriptThread thread) {
        ScriptThread[] newThreads = new ScriptThread[this.threads.length + 1];
        System.arraycopy(this.threads, 0, newThreads, 0, this.threads.length);
        newThreads[this.threads.length] = thread;
        this.threads = newThreads;
    }

    private void removeThread(IScriptThread thread) {
        ScriptThread[] newThreads = new ScriptThread[this.threads.length - 1];
        int i = 0;
        int j = 0;
        while (i < this.threads.length) {
            if (this.threads[i] != thread) {
                newThreads[j++] = this.threads[i];
            }
            ++i;
        }
        this.threads = newThreads;
    }

    protected IScriptThread createThread(IDbgpSession session) throws DbgpException, CoreException {
        ScriptThread thread = new ScriptThread(this.debugTarget, session, this);
        this.addThread(thread);
        DebugEventHelper.fireCreateEvent(thread);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateThread(IScriptThread thread) {
        Object object = this.lock;
        synchronized (object) {
            this.removeThread(thread);
            DebugEventHelper.fireTerminateEvent((IDebugElement)thread);
            if (!this.hasThreads()) {
                this.destroy();
                this.fireAllThreadsTerminated();
            }
        }
    }

    public NewScriptThreadManager(IScriptDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        this.state = 0;
        this.threads = new ScriptThread[0];
    }

    public IScriptDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScriptThread[] getThreads() {
        Object object = this.lock;
        synchronized (object) {
            return (IScriptThread[])this.threads.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.threads.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canResume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i].canResume()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canSuspend() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i].canSuspend()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSuspended() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 1) {
                return false;
            }
            Assert.isTrue((boolean)this.hasThreads());
            int i = 0;
            while (true) {
                if (i >= this.threads.length) {
                    return true;
                }
                if (!this.threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    ScriptThread thread = this.threads[i];
                    if (thread.canResume()) {
                        thread.resume();
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    ScriptThread thread = this.threads[i];
                    if (thread.canSuspend()) {
                        thread.suspend();
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshThreads() {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.threads.length) {
                ScriptThread thread = this.threads[i];
                thread.updateStackFrames();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTerminate() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 0 || this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 3;
        }
    }

    public void terminate() throws DebugException {
        this.debugTarget.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTerminationRequest() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                this.destroy();
            } else if (this.state == 1) {
                this.state = 2;
                IScriptThread[] temp = this.getThreads();
                int i = 0;
                while (i < temp.length) {
                    temp[i].sendTerminationRequest();
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptDbgpThread(IDbgpSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 3 || this.state == 2) {
                return;
            }
            try {
                IScriptThread thread = this.createThread(session);
                boolean first = false;
                if (this.state == 0) {
                    first = true;
                    this.state = 1;
                }
                this.fireThreadAccepted(thread, first);
            }
            catch (DbgpException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void acceptDbgpThreadNotUnavailable() {
    }

    @Override
    public void addListener(IScriptThreadManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IScriptThreadManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireThreadAccepted(IScriptThread thread, boolean first) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).threadAccepted(thread, first);
            ++i;
        }
    }

    protected void fireAllThreadsTerminated() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).allThreadsTerminated();
            ++i;
        }
    }

    @Override
    public boolean isWaitingForThreads() {
        return this.state == 0;
    }

    @Override
    public void configureThread(DbgpDebugger engine, ScriptThread scriptThread) {
    }

    @Override
    public void setScriptThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
    }
}

