/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.mod.dbgp.internal.utils.Base64Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DbgpXmlParser {
    protected DbgpXmlParser() {
    }

    protected static int getPosition(String s) {
        return Integer.parseInt(s.substring(s.indexOf(58) + 1));
    }

    protected static boolean makeBoolean(String s) {
        return Integer.parseInt(s) != 0;
    }

    public static Document parseXml(byte[] xml) throws DbgpProtocolException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(new ByteArrayInputStream(xml));
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new DbgpProtocolException(e);
        }
        catch (SAXException e) {
            throw new DbgpProtocolException(e);
        }
        catch (IOException e) {
            throw new DbgpProtocolException(e);
        }
    }

    protected static String parseContent(Element element) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node e = list.item(i);
            short type = e.getNodeType();
            if (type == 3 || type == 4) {
                return e.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public static String parseBase64Content(Element element) {
        return Base64Helper.decodeString(DbgpXmlParser.parseContent(element));
    }

    public static DbgpDebuggingEngineException checkError(Element element) {
        NodeList errors = element.getElementsByTagName("error");
        if (errors.getLength() > 0) {
            Element error = (Element)errors.item(0);
            int errorCode = Integer.parseInt(error.getAttribute("code"));
            String errorText = "No message";
            NodeList messages = error.getElementsByTagName("message");
            if (messages.getLength() > 0) {
                errorText = DbgpXmlParser.parseContent((Element)messages.item(0));
            }
            return new DbgpDebuggingEngineException(errorCode, errorText);
        }
        return null;
    }

    public static boolean parseSuccess(Element response) {
        if (!response.hasAttribute("success")) {
            return true;
        }
        return DbgpXmlParser.makeBoolean(response.getAttribute("success"));
    }

    protected static String getStringAttribute(Element element, String name) {
        String value = "";
        if (element.hasAttribute(name)) {
            value = element.getAttribute(name);
        }
        return value;
    }

    protected static int getIntAttribute(Element element, String name, int defaultValue) {
        int value = defaultValue;
        if (element.hasAttribute(name)) {
            try {
                value = Integer.parseInt(element.getAttribute(name));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return value;
    }
}

