/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.debugger.pref;

import org.eclipse.dltk.mod.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DebuggerAttachmentConfigurationBlock
extends AbstractConfigurationBlock {
    private Button attachCheckBox;
    private Group opitionsGroup;
    private Button breakCheckBox;
    private Button consoleCheckBox;
    private Button loggingCheckBox;

    public DebuggerAttachmentConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        store.addKeys(this.createKeys());
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.attachCheckBox = this.addCheckBox(composite, "Attach VJET debugger to Java based project", "dbgp_java_based_project_attachment", 0);
        this.attachCheckBox.addSelectionListener((SelectionListener)new Selectionhandler());
        this.opitionsGroup = new Group(composite, 0);
        this.opitionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.opitionsGroup.setLayoutData((Object)new GridData(768));
        this.breakCheckBox = this.addCheckBox((Composite)this.opitionsGroup, "Break on first line", "dbgp_java_based_break_first_line", 10);
        this.consoleCheckBox = this.addCheckBox((Composite)this.opitionsGroup, "Use interactive console", "dbgp_java_based_use_interactive_console", 10);
        this.loggingCheckBox = this.addCheckBox((Composite)this.opitionsGroup, "Enable DBGP logging", "dbgp_java_based_enable_dbgp_logging", 10);
        return composite;
    }

    public void performDefaults() {
        super.performDefaults();
        this.attachCheckBox.setSelection(false);
        this.opitionsGroup.setEnabled(false);
        this.breakCheckBox.setSelection(false);
        this.breakCheckBox.setEnabled(false);
        this.consoleCheckBox.setSelection(false);
        this.consoleCheckBox.setEnabled(false);
        this.loggingCheckBox.setSelection(false);
        this.loggingCheckBox.setEnabled(false);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        OverlayPreferenceStore.OverlayKey attachDebuggerKey = new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "dbgp_java_based_project_attachment");
        OverlayPreferenceStore.OverlayKey breakFristLineKey = new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "dbgp_java_based_break_first_line");
        OverlayPreferenceStore.OverlayKey consoleKey = new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "dbgp_java_based_use_interactive_console");
        OverlayPreferenceStore.OverlayKey loggingKey = new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "dbgp_java_based_enable_dbgp_logging");
        return new OverlayPreferenceStore.OverlayKey[]{attachDebuggerKey, breakFristLineKey, consoleKey, loggingKey};
    }

    private void handleSelection(SelectionEvent e) {
        if (this.attachCheckBox == e.getSource()) {
            if (this.attachCheckBox.getSelection()) {
                this.opitionsGroup.setEnabled(true);
                this.breakCheckBox.setEnabled(true);
                this.consoleCheckBox.setEnabled(true);
                this.loggingCheckBox.setEnabled(true);
            } else {
                this.opitionsGroup.setEnabled(false);
                this.breakCheckBox.setSelection(false);
                this.breakCheckBox.setEnabled(false);
                this.consoleCheckBox.setSelection(false);
                this.consoleCheckBox.setEnabled(false);
                this.loggingCheckBox.setSelection(false);
                this.loggingCheckBox.setEnabled(false);
            }
        }
    }

    private class Selectionhandler
    implements SelectionListener {
        private Selectionhandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            DebuggerAttachmentConfigurationBlock.this.handleSelection(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DebuggerAttachmentConfigurationBlock.this.handleSelection(e);
        }
    }
}

