/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.html;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.ScriptDebugManager;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptDebugModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;

public class HtmlBreakpointUtils {
    private HtmlBreakpointUtils() {
    }

    public static void addLineBreakpoint(ITextEditor textEditor, int lineNumber) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = BreakpointUtils.getBreakpointResource((ITextEditor)textEditor);
        try {
            IRegion line = document.getLineInformation(lineNumber - 1);
            int start = line.getOffset();
            int end = start + line.getLength();
            String debugModelId = ScriptDebugManager.getInstance().getDebugModelByNature("org.eclipse.vjet.core.nature");
            IPath location = BreakpointUtils.getBreakpointResourceLocation((ITextEditor)textEditor);
            ScriptDebugModel.createLineBreakpoint((String)debugModelId, (IResource)resource, (IPath)location, (int)lineNumber, (int)start, (int)end, (boolean)true, null);
        }
        catch (BadLocationException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    public static ILineBreakpoint findLineBreakpoint(ITextEditor editor, int lineNumber) throws CoreException {
        IResource resource = BreakpointUtils.getBreakpointResource((ITextEditor)editor);
        String debugModelId = ScriptDebugManager.getInstance().getDebugModelByNature("org.eclipse.vjet.core.nature");
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(debugModelId);
        IPath breakPointResourceLocation = BreakpointUtils.getBreakpointResourceLocation((ITextEditor)editor);
        if (breakPointResourceLocation == null) {
            return null;
        }
        String location = breakPointResourceLocation.toPortableString();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            IResource bpResource = breakpoint.getMarker().getResource();
            String bpLocation = (String)breakpoint.getMarker().getAttribute("location");
            if (resource.equals((Object)bpResource) && location.equals(bpLocation)) {
                ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                try {
                    if (lineBreakpoint.getLineNumber() == lineNumber) {
                        return lineBreakpoint;
                    }
                }
                catch (CoreException e) {
                    DLTKDebugUIPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
        return null;
    }
}

