/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.html;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.mod.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlBrowserTypeBlock;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlLocationBlock;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlMainClassBlock;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlMainTab;

public class HtmlArgumentsTab
extends AbstractLaunchConfigurationTab {
    private static String tabName = "VJO Arguments";
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    private HtmlMainTab htmlMainTab;
    protected HtmlLocationBlock vjoHtmlLocationBlock;
    protected HtmlMainClassBlock vjoMainClassBlock;
    protected HtmlBrowserTypeBlock vjoBrowserTypeBlock;

    public HtmlArgumentsTab(HtmlMainTab htmlMainTab) {
        this.htmlMainTab = htmlMainTab;
        this.vjoHtmlLocationBlock = new HtmlLocationBlock(this);
        this.vjoMainClassBlock = new HtmlMainClassBlock();
        this.vjoBrowserTypeBlock = new HtmlBrowserTypeBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.vjoHtmlLocationBlock.createControl(comp);
        this.createVerticalSpacer(comp, 4);
        this.vjoMainClassBlock.createControl(comp);
        this.createVerticalSpacer(comp, 4);
        Group group = new Group(comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = "Program arguments";
        group.setText(controlName);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                HtmlArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        ControlAccessibleListener.addListener((Control)this.fPrgmArgumentsText, (String)group.getText());
        String buttonLabel = "Variables";
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, buttonLabel, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(HtmlArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    HtmlArgumentsTab.this.fPrgmArgumentsText.insert(variable);
                }
                HtmlArgumentsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createVerticalSpacer(comp, 4);
        this.vjoBrowserTypeBlock.createControl(comp);
        this.createVerticalSpacer(comp, 4);
    }

    public IProject getProject() {
        return this.htmlMainTab.getSelectedProject();
    }

    public Image getImage() {
        return ScriptDebugImages.get((String)"IMG_VIEW_ARGUMENTS_TAB");
    }

    public String getName() {
        return tabName;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        this.vjoHtmlLocationBlock.performApply(configuration);
        this.vjoMainClassBlock.performApply(configuration);
        this.vjoBrowserTypeBlock.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jdt.launching.MAIN_TYPE", "org.eclipse.vjet.vjo.runner.VjoRunner");
        this.vjoHtmlLocationBlock.setDefaults(configuration);
        this.vjoMainClassBlock.setDefaults(configuration);
        this.vjoBrowserTypeBlock.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", ""));
            this.vjoHtmlLocationBlock.initializeFrom(configuration);
            this.vjoMainClassBlock.initializeFrom(configuration);
            this.vjoBrowserTypeBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.vjoHtmlLocationBlock.setLaunchConfigurationDialog(dialog);
        this.vjoMainClassBlock.setLaunchConfigurationDialog(dialog);
        this.vjoBrowserTypeBlock.setLaunchConfigurationDialog(dialog);
    }
}

