/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.factory.set.primitive.ImmutableCharSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableCharSetFactory;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableCharSetFactoryImpl;

/**
 * CharSets is a static utility for creating {@link ImmutableCharSetFactory}.
 * This file was automatically generated from template file primitiveSets.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class CharSets
{
    public static final ImmutableCharSetFactory immutable = new ImmutableCharSetFactoryImpl();
    public static final MutableCharSetFactory mutable = new MutableCharSetFactoryImpl();

    private CharSets()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
