/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.Socket;

public class SocketDefaults {
    private static final Logger log = LoggerFactory.getLogger(SocketDefaults.class);
    public static final SocketDefaults instance = new SocketDefaults();
    private boolean tcpNoDelay = true;
    private int tcpSendBufferSize;
    private int tcpReceiveBufferSize;
    private boolean tcpKeepAlive;
    private boolean reuseAddress;
    private int soLinger;
    private int trafficClass;

    private SocketDefaults() {
        try {
            Socket csock = new Socket();
            this.tcpNoDelay = csock.getTcpNoDelay();
            this.tcpSendBufferSize = csock.getSendBufferSize();
            this.tcpReceiveBufferSize = csock.getReceiveBufferSize();
            this.tcpKeepAlive = csock.getKeepAlive();
            this.reuseAddress = csock.getReuseAddress();
            this.soLinger = csock.getSoLinger();
            this.trafficClass = csock.getTrafficClass();
        }
        catch (Exception e) {
            log.warn("Failed to read socket defaults, using Vert.x defaults instead");
            this.tcpNoDelay = true;
            this.tcpSendBufferSize = 8192;
            this.tcpReceiveBufferSize = 32768;
            this.tcpKeepAlive = false;
            this.reuseAddress = false;
            this.soLinger = -1;
            this.trafficClass = 0;
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTcpSendBufferSize() {
        return this.tcpSendBufferSize;
    }

    public int getTcpReceiveBufferSize() {
        return this.tcpReceiveBufferSize;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }
}

