/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public final class ErrorsWarningsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences of the on-the-fly analyzer";
    private static final String REPORTUNSUPPORTEDCONSTRUCTS = "Language constructs not supported yet:";
    private static final String REPORTUNSUPPORTEDCONSTRUCTS_TOOLTIP = "For example pattern subtyping in TTCN-3.";
    private static final String HANDLEDEFAULTASOPTIONAL = "DEFAULT elements of ASN.1 sequence and set types as OPTIONAL:";
    private static final String HANDLEDEFAULTASOPTIONALTOOTIP = "Handle the DEFAULT elements of set and sequence ASN.1 types as being optional.\nThis is compatibility opition.";
    private static final String REPORT_IGNORED_PREPROCESSOR_DIRECTIVES = "Report ignored preprocessor directives:";
    private static final String REPORT_IGNORED_PREPROCESSOR_DIRECTIVES_TOOLTIP = "Some preprocessor directives (#line,#pragma,etc.) are ignored.\nThese should either be removed or the file is an intermediate file (already preprocessed ttcnpp) that contains line markers.\nIt is probably a bad idea to edit the intermediate file instead of the original ttcnpp file.";
    private static final String REPORTTYPECOMPATIBILITY = "Report uses of structured-type compatibility:";
    private static final String REPORTTYPECOMPATIBILITY_TOOLTIP = "When structured-type compatibility is used in the code.";
    private static final String REPORTERRORSINEXTENSIONSYNTAX = "Report incorrect syntax in extension attributes:";
    private static final String REPORTERRORSINEXTENSIONSYNTAX_TOOLTIP = "According to the standard syntax errors in the extension attribute should not be reported, but should be assumed as correct for some other tool.";
    private static final String REPORT_STRICT_CONSTANTS = "Stricter checks for constants, templates and variables";
    private static final String REPORT_STRICT_CONSTANTS_TOOLTIP = "Although it is valid to leave fields of constants and literals unbound, in some cases this was not the intention.";
    private static final String REPORT_DOC_COMMENT_INCONSISTENCY = "Check for possible inconsistency between the document comment and its related definition";
    private static final String REPORT_DOC_COMMENT_INCONSISTENCY_TOOLTIP = "In better case, inconsistency between the comment and its related definition means the lack of proper commenting, in worse case it can indicate possible programming problems.";
    private static final String REPORT_MODULE_NAME_REUSE = "Report reuse of module name as identifier";
    private static final String REPORT_MODULE_NAME_REUSE_TOOLTIP = "According to the TTCN-3 standard, the name of an identifier cannot be the same as that of the containing module or an imported module";
    private static final String REPORT_DUPLICATED_UNIQUE_FIELD_VALUE = "Report if two ASN.1 information objects in the information object set have the same identifier (UNIQUE) field value";
    private static final String REPORT_DUPLICATED_UNIQUE_FIELD_VALUE_TOOLTIP = "According to the ASN.1 standard, a fixed-type value field of a class, selected to provide unique identification of information objects in that class.\nValues of the identifier field, if supplied, are required to be unambiguous within any information object set that is defined for that class.\nThey may, but need not, serve to unambiguously identify information objects of that class within some broader scope.";
    private static final String[][] IGNORE_WARNING_ERROR = new String[][]{{"Ignore", "ignore"}, {"Warning", "warning"}, {"Error", "error"}};
    private boolean changed = false;
    private Composite pagecomp;

    public ErrorsWarningsPreferencePage() {
        super(1);
    }

    private ExpandableComposite createExtendableComposite(final Composite parent, String title) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, 50);
        ex.setText(title);
        ex.setExpanded(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        ex.setLayoutData((Object)data);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite temp;
                for (temp = parent; temp != null && !(temp instanceof ScrolledComposite); temp = temp.getParent()) {
                }
                if (temp != null) {
                    Point point = ErrorsWarningsPreferencePage.this.pagecomp.computeSize(-1, -1);
                    ((ScrolledComposite)temp).setMinSize(point);
                    ((ScrolledComposite)temp).layout(true, true);
                }
            }
        });
        return ex;
    }

    protected Control createContents(Composite parent) {
        this.pagecomp = new Composite(parent, 0);
        this.pagecomp.setLayout((Layout)new GridLayout(1, false));
        this.pagecomp.setLayoutData((Object)new GridData(1808));
        return super.createContents(this.pagecomp);
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        this.createCodeStyleSection(tempParent);
        this.createUnnecessaryCodeSection(tempParent);
        this.createPotentialProgrammingProblemsSection(tempParent);
    }

    private void createCodeStyleSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Code style problems");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(true);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportUnsupportedConstructs", REPORTUNSUPPORTEDCONSTRUCTS, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTUNSUPPORTEDCONSTRUCTS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
        BooleanFieldEditor defaultAsOptional = new BooleanFieldEditor("org.eclipse.titan.designer.defaultAsOptional", HANDLEDEFAULTASOPTIONAL, 1, comp);
        defaultAsOptional.getLabelControl(comp).setToolTipText(HANDLEDEFAULTASOPTIONALTOOTIP);
        defaultAsOptional.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)defaultAsOptional);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportTypeCompatibility", REPORTTYPECOMPATIBILITY, IGNORE_WARNING_ERROR, comp);
        text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTTYPECOMPATIBILITY_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
        comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportStrictConstants", REPORT_STRICT_CONSTANTS, IGNORE_WARNING_ERROR, comp);
        comboedit.getLabelControl(comp).setToolTipText(REPORT_STRICT_CONSTANTS_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
    }

    private void createPotentialProgrammingProblemsSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Potential programming problems");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportErrorsInExtensionSyntax", REPORTERRORSINEXTENSIONSYNTAX, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORTERRORSINEXTENSIONSYNTAX_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
        ComboFieldEditor comboeditModuleName = new ComboFieldEditor("org.eclipse.titan.designer.reportModuleNameReuse", REPORT_MODULE_NAME_REUSE, IGNORE_WARNING_ERROR, comp);
        Label textModuleName = comboeditModuleName.getLabelControl(comp);
        textModuleName.setToolTipText(REPORT_MODULE_NAME_REUSE_TOOLTIP);
        comboeditModuleName.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboeditModuleName);
        ComboFieldEditor comboeditDocComment = new ComboFieldEditor("org.eclipse.titan.designer.reportDocCommentInconsistency", REPORT_DOC_COMMENT_INCONSISTENCY, IGNORE_WARNING_ERROR, comp);
        Label textDocComment = comboeditDocComment.getLabelControl(comp);
        textDocComment.setToolTipText(REPORT_DOC_COMMENT_INCONSISTENCY_TOOLTIP);
        comboeditDocComment.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboeditDocComment);
        ComboFieldEditor comboeditUniqueField = new ComboFieldEditor("org.eclipse.titan.designer.reportDuplicatedUniqueFieldValue", REPORT_DUPLICATED_UNIQUE_FIELD_VALUE, IGNORE_WARNING_ERROR, comp);
        Label textUniqueField = comboeditUniqueField.getLabelControl(comp);
        textUniqueField.setToolTipText(REPORT_DUPLICATED_UNIQUE_FIELD_VALUE_TOOLTIP);
        comboeditUniqueField.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboeditUniqueField);
    }

    private void createUnnecessaryCodeSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "Unnecessary code");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        ComboFieldEditor comboedit = new ComboFieldEditor("org.eclipse.titan.designer.reportIgnoredPreprocessorDirectives", REPORT_IGNORED_PREPROCESSOR_DIRECTIVES, IGNORE_WARNING_ERROR, comp);
        Label text = comboedit.getLabelControl(comp);
        text.setToolTipText(REPORT_IGNORED_PREPROCESSOR_DIRECTIVES_TOOLTIP);
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ErrorsWarningsPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.changed && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            this.changed = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning(null, (String)"Error/Warning settings changed", (String)"Error/Warning settings have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
                }
            });
            GlobalParser.clearSemanticInformation();
            GlobalParser.reAnalyzeSemantically();
        }
        return result;
    }
}

