/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.text.MessageFormat;
import java.util.List;
import java.util.Stack;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.parsers.preprocess.PreprocessorDirective;
import org.eclipse.titan.designer.parsers.ttcn3parser.ConditionalStateMachine;

class ConditionalStateStack {
    Stack<ConditionalStateMachine> stateStack = new Stack();
    List<TITANMarker> unsupportedConstructs;

    public ConditionalStateStack(List<TITANMarker> unsupportedConstructs) {
        this.unsupportedConstructs = unsupportedConstructs;
    }

    public void processDirective(PreprocessorDirective ppDirective) {
        switch (ppDirective.type) {
            case IF: 
            case IFDEF: 
            case IFNDEF: {
                ConditionalStateMachine csm = new ConditionalStateMachine(ppDirective);
                this.stateStack.add(csm);
                break;
            }
            case ELIF: 
            case ELSE: 
            case ENDIF: {
                if (this.stateStack.isEmpty()) {
                    TITANMarker marker = new TITANMarker(MessageFormat.format("Directive {0} without corresponding #if/#ifdef/#ifndef directive", ppDirective.type.getName()), ppDirective.line, -1, -1, 2, 1);
                    this.unsupportedConstructs.add(marker);
                    break;
                }
                ConditionalStateMachine topState = this.stateStack.peek();
                topState.transition(ppDirective, this.unsupportedConstructs);
                if (!topState.hasEnded()) break;
                this.stateStack.pop();
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
            }
        }
    }

    public boolean isPassing() {
        for (ConditionalStateMachine csm : this.stateStack) {
            if (csm.isPassing()) continue;
            return false;
        }
        return true;
    }

    public void eofCheck() {
        for (ConditionalStateMachine csm : this.stateStack) {
            TITANMarker marker = new TITANMarker(MessageFormat.format("{0} directive was not terminated", csm.beginDirective.type.getName()), csm.beginDirective.line, -1, -1, 2, 1);
            this.unsupportedConstructs.add(marker);
        }
    }
}

