/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.BaseTextHover;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.controls.HoverProposal;
import org.eclipse.titan.designer.editors.controls.MarkerHoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3ReferenceParser;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class TextHover
extends BaseTextHover
implements ITextHoverExtension,
ITextHoverExtension2 {
    private final ISourceViewer sourceViewer;
    private final IEditorPart editor;

    public TextHover(ISourceViewer sourceViewer, IEditorPart editor) {
        this.sourceViewer = sourceViewer;
        this.editor = editor;
    }

    @Override
    protected ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    @Override
    protected IEditorPart getTargetEditor() {
        return this.editor;
    }

    @Override
    protected IReferenceParser getReferenceParser() {
        return new TTCN3ReferenceParser(false);
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        boolean enableCodeHoverPopups = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableHoverWindowPopups", true, null);
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule == null) {
            return "";
        }
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            StringBuilder markerInfo = new StringBuilder();
            ArrayList<HoverProposal> proposals = new ArrayList<HoverProposal>();
            while (iterator.hasNext()) {
                MarkerAnnotation actualMarker;
                Position markerPosition;
                Object o = iterator.next();
                if (o instanceof MarkerAnnotation && (markerPosition = annotationModel.getPosition((Annotation)(actualMarker = (MarkerAnnotation)o))).getOffset() <= hoverRegion.getOffset() && markerPosition.getOffset() + markerPosition.getLength() >= hoverRegion.getOffset()) {
                    String message = actualMarker.getText();
                    if (message == null) {
                        ErrorReporter.INTERNAL_ERROR((String)("The marker at " + markerPosition.getOffset() + " does not seem to have any text"));
                    }
                    if (markerInfo == null) {
                        // empty if block
                    }
                    markerInfo.append(message);
                    Object attr = null;
                    try {
                        attr = actualMarker.getMarker().getAttribute("proposal");
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (attr instanceof HoverProposal[]) {
                        HoverProposal[] propsInMarker = (HoverProposal[])attr;
                        for (int i = 0; i < propsInMarker.length; ++i) {
                            HoverProposal propEntry = propsInMarker[i];
                            propEntry.setMarker(actualMarker.getMarker(), actualMarker);
                            proposals.add(propEntry);
                        }
                    }
                }
                if (markerInfo.length() <= 0) continue;
                HoverProposal[] propArr = new HoverProposal[]{};
                propArr = proposals.toArray(propArr);
                return new MarkerHoverContent(markerInfo.toString(), propArr);
            }
        }
        if (!enableCodeHoverPopups) {
            return "";
        }
        Ttcn3HoverContent info = null;
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(hoverRegion.getOffset());
        tempModule.accept(visitor);
        Declaration declaration = visitor.getReferencedDeclaration();
        if (declaration == null) {
            return "";
        }
        ICommentable commentable = declaration.getCommentable();
        if (commentable == null) {
            return "";
        }
        info = commentable.getHoverContent(this.editor);
        if (info == null) {
            return "";
        }
        return info;
    }

    @Override
    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new Ttcn3HoverInfoControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }
}

