/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class LengthofExpression
extends Expression_Value {
    private static final String OPERANDERROR = "Cannot determine the argument type of `lengthof()'' operation";
    private static final String UNEXPECTEDOPERAND = "The first operand of operation `lengthof' should be a string, a `record of', a `set of' or an `array' value";
    private final TemplateInstance templateInstance;

    public LengthofExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.LENGTHOF_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.templateInstance != null && this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("lengthof(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            return true;
        }
        if (this.templateInstance.getDerivedReference() != null) {
            return true;
        }
        ITTCN3Template template = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
            return ((SpecificValue_Template)this.templateInstance.getTemplateBody()).getSpecificValue().isUnfoldable(timestamp, expectedValue, referenceChain);
        }
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        IType governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (governor == null) {
            template = template.setLoweridToReference(timestamp);
            governor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance.getLocation().reportSemanticError(OPERANDERROR);
            }
            this.setIsErroneous(true);
            return;
        }
        IType.Type_type typetype = this.templateInstance.getExpressionReturntype(timestamp, internalExpectation);
        switch (typetype) {
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: 
            case TYPE_ARRAY: {
                break;
            }
            case TYPE_UNDEFINED: {
                break;
            }
            default: {
                this.templateInstance.getLocation().reportSemanticError(UNEXPECTEDOPERAND);
                this.setIsErroneous(true);
                return;
            }
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, expectedValue);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        int length;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        TTCN3Template template = this.templateInstance.getTemplateBody();
        IValue value = ((SpecificValue_Template)template).getSpecificValue().getValueRefdLast(timestamp, referenceChain);
        switch (value.getValuetype()) {
            case CHARSTRING_VALUE: {
                length = ((Charstring_Value)value).getValueLength();
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                length = ((UniversalCharstring_Value)value).getValueLength();
                break;
            }
            case BITSTRING_VALUE: {
                length = ((Bitstring_Value)value).getValueLength();
                break;
            }
            case HEXSTRING_VALUE: {
                length = ((Hexstring_Value)value).getValueLength();
                break;
            }
            case OCTETSTRING_VALUE: {
                length = ((Octetstring_Value)value).getValueLength();
                break;
            }
            case SEQUENCEOF_VALUE: {
                length = ((SequenceOf_Value)value).getNofComponents();
                break;
            }
            case SETOF_VALUE: {
                length = ((SetOf_Value)value).getNofComponents();
                break;
            }
            case ARRAY_VALUE: {
                length = ((Array_Value)value).getNofComponents();
                break;
            }
            default: {
                this.setIsErroneous(true);
                return this.lastValue;
            }
        }
        this.lastValue = new Integer_Value(length);
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.templateInstance != null) {
            referenceChain.markState();
            this.templateInstance.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.templateInstance.hasSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        TTCN3Template templateBody = this.templateInstance.getTemplateBody();
        if (this.templateInstance.getDerivedReference() == null && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)templateBody.getTemplatetype()) && templateBody.getLengthRestriction() == null && !templateBody.getIfPresent()) {
            IValue value = ((SpecificValue_Template)templateBody).getSpecificValue();
            value.generateCodeExpressionMandatory(aData, expression, true);
        } else {
            this.templateInstance.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        }
        expression.expression.append(".lengthof()");
    }
}

