/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PreprocessorIncludedOptionsData {
    public static final String TTCN3_PREPROCESSOR_INCLUDES_PROPERTY = "TTCN3preprocessorIncludes";
    public static final String TTCN3_PREPROCESSOR_INCLUDES_TAG = "TTCN3preprocessorIncludes";
    public static final String PREPROCESSOR_INCLUDES_PROPERTY = "preprocessorIncludes";
    public static final String PREPROCESSOR_INCLUDES_TAG = "preprocessorIncludes";
    private static final String[] PROPERTIES = new String[]{"TTCN3preprocessorIncludes", "preprocessorIncludes"};
    private static final String[] TAGS = new String[]{"TTCN3preprocessorIncludes", "preprocessorIncludes"};
    private static final String[] DEFAULT_VALUES = new String[]{"", ""};

    private PreprocessorIncludedOptionsData() {
    }

    public static String[] getTTCN3PreprocessorIncludes(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessorIncludes"));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting TTCN-3 preprocessor includes of `" + project.getName() + "'"), (Throwable)e);
            return new String[0];
        }
    }

    public static String[] getPreprocessorIncludes(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "preprocessorIncludes"));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting preprocessor includes of `" + project.getName() + "'"), (Throwable)e);
            return new String[0];
        }
    }

    public static void removeTITANAttributes(IProject project) {
        for (int i = 0; i < PROPERTIES.length; ++i) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]), null);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing attribute " + PROPERTIES[i] + " of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            for (int j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                NodeList subResources = resource.getChildNodes();
                ArrayList<String> values = new ArrayList<String>();
                for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                    Node subResource = subResources.item(i2);
                    if (!"listItem".equals(subResource.getNodeName())) continue;
                    values.add(subResource.getTextContent());
                }
                newValues[j] = ListConverter.convertFromList(values.toArray(new String[values.size()]));
            }
        }
        for (i = 0; i < PROPERTIES.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading property " + PROPERTIES[i] + " of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        for (int i = 0; i < TAGS.length; ++i) {
            QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String temp = project.getPersistentProperty(name);
                String[] tempList = ListConverter.convertToList(temp);
                if (tempList.length <= 0) continue;
                Element list = document.createElement(TAGS[i]);
                makefileSettings.appendChild(list);
                for (int j = 0; j < tempList.length; ++j) {
                    if (tempList[j] == null || tempList[j].length() <= 0) continue;
                    Element item = document.createElement("listItem");
                    item.appendChild(document.createTextNode(tempList[j]));
                    list.appendChild(item);
                }
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving property " + PROPERTIES[i] + " of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        int j;
        int i;
        NodeList resourceList = source.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            for (j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                NodeList subResources = resource.getChildNodes();
                ArrayList<String> values = new ArrayList<String>();
                for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                    Node subResource = subResources.item(i2);
                    if (!"listItem".equals(subResource.getNodeName())) continue;
                    values.add(subResource.getTextContent());
                }
                newValues[j] = ListConverter.convertFromList(values.toArray(new String[values.size()]));
            }
        }
        for (i = 0; i < TAGS.length; ++i) {
            String temp = newValues[i];
            String[] tempList = ListConverter.convertToList(temp);
            if (!saveDefaultValues && tempList.length <= 0) continue;
            Element list = document.createElement(TAGS[i]);
            makefileSettings.appendChild(list);
            for (j = 0; j < tempList.length; ++j) {
                if (tempList[j] == null || tempList[j].length() <= 0) continue;
                Element item = document.createElement("listItem");
                item.appendChild(document.createTextNode(tempList[j]));
                list.appendChild(item);
            }
        }
    }
}

