/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TimerRunningExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The operand of operation `timer running'': Reference to a single timer `{0}'' cannot have field or array sub-references";
    private static final String OPERANDERROR2 = "The operand of operation `timer running'' should be a timer instead of `{0}''";
    private static final String OPERATIONNAME = "timer running";
    private final Reference reference;
    private final boolean any_from;
    private final Reference indexRedirection;

    public TimerRunningExpression(Reference reference) {
        this.reference = reference;
        this.any_from = false;
        this.indexRedirection = null;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    public TimerRunningExpression(Reference reference, boolean any_from, Reference index_redirect) {
        this.reference = reference;
        this.any_from = any_from;
        this.indexRedirection = index_redirect;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
        if (index_redirect != null) {
            index_redirect.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.TIMER_RUNNING_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.reference.getDisplayName()).append(".running");
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference == child) {
            return builder.append(".<operand>");
        }
        if (this.indexRedirection == child) {
            return builder.append(".redirectIndex");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.reference == null) {
            return;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_TIMER: {
                ArrayDimensions dimensions = ((Def_Timer)assignment).getDimensions();
                if (dimensions != null) {
                    dimensions.checkIndices(timestamp, this.reference, "timer", false, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, this.any_from);
                    break;
                }
                if (this.reference.getSubreferences().size() <= 1) break;
                this.reference.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR, assignment.getIdentifier().getDisplayName()));
                break;
            }
            case A_PAR_TIMER: {
                if (this.reference.getSubreferences().size() <= 1) break;
                this.reference.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR, assignment.getIdentifier().getDisplayName()));
                break;
            }
            default: {
                this.reference.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR2, assignment.getDescription()));
                this.setIsErroneous(true);
            }
        }
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, true, true, false);
        if (this.indexRedirection != null) {
            Statement.checkIndexRedirection(timestamp, this.indexRedirection, assignment == null ? null : ((Def_Timer)assignment).getDimensions(), this.any_from, "timer");
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.reference == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.updateSyntax(reparser, false);
            reparser.updateLocation(this.indexRedirection.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.reference != null && !this.reference.accept(v)) {
            return false;
        }
        return this.indexRedirection == null || this.indexRedirection.accept(v);
    }

    @Override
    public boolean canGenerateSingleExpression() {
        if (this.indexRedirection != null) {
            return false;
        }
        return this.reference != null && this.reference.hasSingleExpression();
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.reference.generateCode(aData, expression);
        TimerRunningExpression.generateCodeExpressionOptionalFieldReference(aData, expression, this.reference);
        expression.expression.append(".running(");
        if (this.indexRedirection == null) {
            expression.expression.append("null");
        } else {
            Statement.generateCodeIndexRedirect(aData, expression, this.indexRedirection, this.getMyScope());
        }
        expression.expression.append(')');
    }
}

