/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Enumerated_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionUtilities;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class GreaterThanExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `>' operation should be an integer, float or enumerated value";
    private static final String SECONDOPERANDERROR = "The second operand of the `>' operation should be an integer, float or enumerated value";
    private final Value value1;
    private final Value value2;

    public GreaterThanExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.GREATERTHAN_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value1 != null && this.value1.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.value2 != null && this.value2.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" > ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value1 != null) {
            this.value1.setCodeSection(codeSection);
        }
        if (this.value2 != null) {
            this.value2.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return;
        }
        ExpressionUtilities.checkExpressionOperatorCompatibility(timestamp, (Expression_Value)this, referenceChain, expectedValue, this.value1, this.value2);
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType1) {
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
            default: {
                this.value1.getLocation().reportSemanticError(FIRSTOPERANDERROR);
                this.setIsErroneous(true);
            }
        }
        this.value2.setLoweridToReference(timestamp);
        IType.Type_type tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType2) {
            case TYPE_INTEGER: 
            case TYPE_REAL: 
            case TYPE_TTCN3_ENUMERATED: 
            case TYPE_ASN1_ENUMERATED: {
                this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                break;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
            default: {
                this.value2.getLocation().reportSemanticError(SECONDOPERANDERROR);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        if (last1.getIsErroneous(timestamp) || last2.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        switch (last1.getValuetype()) {
            case INTEGER_VALUE: {
                this.lastValue = new Boolean_Value(((Integer_Value)last1).compareTo((Integer_Value)last2) > 0);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case REAL_VALUE: {
                double float1 = ((Real_Value)last1).getValue();
                double float2 = ((Real_Value)last2).getValue();
                this.lastValue = new Boolean_Value(Double.compare(float1, float2) > 0);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case ENUMERATED_VALUE: {
                IType governor1 = last1.getExpressionGovernor(timestamp, expectedValue);
                governor1 = governor1.getTypeRefdLast(timestamp);
                IType governor2 = last2.getExpressionGovernor(timestamp, expectedValue);
                governor2 = governor2.getTypeRefdLast(timestamp);
                if (governor1 instanceof TTCN3_Enumerated_Type) {
                    EnumItem item1 = ((TTCN3_Enumerated_Type)governor1).getEnumItemWithName(((Enumerated_Value)last1).getValue());
                    EnumItem item2 = ((TTCN3_Enumerated_Type)governor2).getEnumItemWithName(((Enumerated_Value)last2).getValue());
                    this.lastValue = new Boolean_Value(((Integer_Value)item1.getValue()).intValue() > ((Integer_Value)item2.getValue()).intValue());
                    this.lastValue.copyGeneralProperties(this);
                    break;
                }
                EnumItem item1 = ((ASN1_Enumerated_Type)governor1).getEnumItemWithName(((Enumerated_Value)last1).getValue());
                EnumItem item2 = ((ASN1_Enumerated_Type)governor2).getEnumItemWithName(((Enumerated_Value)last2).getValue());
                this.lastValue = new Boolean_Value(((Integer_Value)item1.getValue()).intValue() > ((Integer_Value)item2.getValue()).intValue());
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value1 != null) {
            this.value1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value2 != null) {
            this.value2.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value1.canGenerateSingleExpression() && this.value2.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.value1.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(".is_greater_than( ");
        if (this.value2.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            this.value2.generateCodeExpressionMandatory(aData, expression, false);
        } else {
            IValue refdLast = this.value2.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
            refdLast.generateCodeExpression(aData, expression, false);
        }
        expression.expression.append(" )");
    }
}

