/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.ASN1.Defined_Reference;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.ASN1.definitions.Symbols;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Exports
extends ASTNode
implements ILocateableNode {
    private ASN1Module module;
    private final Symbols symbols;
    private final boolean exportAll;
    private Location location = NULL_Location.INSTANCE;
    private CompilationTimeStamp lastCompilationTimeStamp;

    public Exports(boolean exportAll) {
        this.exportAll = exportAll;
        this.symbols = exportAll ? null : new Symbols();
    }

    public Exports(Symbols symbols) {
        this.exportAll = false;
        this.symbols = symbols;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setMyModule(ASN1Module module) {
        this.module = module;
    }

    public boolean exportsSymbol(CompilationTimeStamp timestamp, Identifier id) {
        this.check(timestamp);
        if (this.exportAll) {
            return true;
        }
        return this.symbols.hasSymbol(id.getName());
    }

    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastCompilationTimeStamp && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        if (this.exportAll) {
            this.lastCompilationTimeStamp = timestamp;
            return;
        }
        this.symbols.checkUniqueness(timestamp);
        for (int i = 0; i < this.symbols.size(); ++i) {
            ArrayList<ISubReference> list = new ArrayList<ISubReference>();
            list.add(new FieldSubReference(this.symbols.getNthElement(i)));
            Defined_Reference reference = new Defined_Reference(null, list);
            this.module.getAssBySRef(timestamp, reference);
        }
        this.lastCompilationTimeStamp = timestamp;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

