/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.types.ProblemNameToPreferenceMapper;
import org.eclipse.titanium.markers.types.ProblemType;
import org.eclipse.titanium.markers.types.TaskType;
import org.eclipse.titanium.preferences.pages.TimeDataEntry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RepairTimePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Here we can set the repair times for code smells";
    private final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    private Map<ProblemType, TimeDataEntry> storedValues = new HashMap<ProblemType, TimeDataEntry>();

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(4, false));
        new Label(ret, 0).setText("");
        new Label(ret, 0).setText("Minimal");
        new Label(ret, 0).setText("Average");
        new Label(ret, 0).setText("Maximal");
        for (TaskType taskType : TaskType.values()) {
            this.makeNewRow(ret, taskType);
        }
        for (Enum enum_ : CodeSmellType.values()) {
            this.makeNewRow(ret, (ProblemType)((Object)enum_));
        }
        return ret;
    }

    public boolean performOk() {
        TimeDataEntry value;
        for (TaskType taskType : TaskType.values()) {
            value = this.storedValues.get(taskType);
            if (value == null) continue;
            this.setAvgValue(taskType, value.avgTime);
            this.setMinValue(taskType, value.minTime);
            this.setMaxValue(taskType, value.maxTime);
        }
        for (Enum enum_ : CodeSmellType.values()) {
            value = this.storedValues.get(enum_);
            if (value == null) continue;
            this.setAvgValue((ProblemType)((Object)enum_), value.avgTime);
            this.setMinValue((ProblemType)((Object)enum_), value.minTime);
            this.setMaxValue((ProblemType)((Object)enum_), value.maxTime);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        for (TaskType taskType : TaskType.values()) {
            this.setAvgValue(taskType, taskType.getAvgDefaultTime());
            this.setMinValue(taskType, taskType.getMinDefaultTime());
            this.setMaxValue(taskType, taskType.getMaxDefaultTime());
        }
        for (Enum enum_ : CodeSmellType.values()) {
            this.setAvgValue((ProblemType)((Object)enum_), ((CodeSmellType)enum_).getAvgDefaultTime());
            this.setMinValue((ProblemType)((Object)enum_), ((CodeSmellType)enum_).getMinDefaultTime());
            this.setMaxValue((ProblemType)((Object)enum_), ((CodeSmellType)enum_).getMaxDefaultTime());
        }
        this.refresh();
        super.performDefaults();
    }

    private void refresh() {
        this.storedValues = new HashMap<ProblemType, TimeDataEntry>();
        this.createContents(this.getShell().getParent());
    }

    private void setAvgValue(ProblemType smell, Double value) {
        this.prefStore.setValue(ProblemNameToPreferenceMapper.nameSmellAvgTime(smell.toString()), value.doubleValue());
    }

    private void setMinValue(ProblemType smell, Double value) {
        this.prefStore.setValue(ProblemNameToPreferenceMapper.nameSmellMinTime(smell.toString()), value.doubleValue());
    }

    private void setMaxValue(ProblemType smell, Double value) {
        this.prefStore.setValue(ProblemNameToPreferenceMapper.nameSmellMaxTime(smell.toString()), value.doubleValue());
    }

    private void makeNewRow(Composite parent, final ProblemType codeSmell) {
        Label lblValue = new Label(parent, 0);
        lblValue.setText(codeSmell.getHumanReadableName() + ": ");
        double minTime = codeSmell.getMinRepairTime();
        double avgTime = codeSmell.getAvgRepairTime();
        double maxTime = codeSmell.getMaxRepairTime();
        this.storedValues.put(codeSmell, new TimeDataEntry(minTime, avgTime, maxTime));
        final Text minText = new Text(parent, 2048);
        try {
            minText.setText(String.valueOf(minTime));
        }
        catch (NumberFormatException e) {
            minText.setText("0.0");
        }
        minText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    TimeDataEntry times = (TimeDataEntry)RepairTimePage.this.storedValues.get(codeSmell);
                    if (times != null) {
                        times.minTime = Double.parseDouble(minText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        final Text avgText = new Text(parent, 2048);
        try {
            avgText.setText(String.valueOf(avgTime));
        }
        catch (NumberFormatException e) {
            avgText.setText("0.0");
        }
        avgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    TimeDataEntry times = (TimeDataEntry)RepairTimePage.this.storedValues.get(codeSmell);
                    if (times != null) {
                        times.avgTime = Double.parseDouble(avgText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        final Text maxText = new Text(parent, 2048);
        try {
            maxText.setText(String.valueOf(maxTime));
        }
        catch (NumberFormatException e) {
            maxText.setText("0.0");
        }
        maxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    TimeDataEntry times = (TimeDataEntry)RepairTimePage.this.storedValues.get(codeSmell);
                    if (times != null) {
                        times.maxTime = Double.parseDouble(maxText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }
}

