import type { LanguageServicePlugin, DocumentSelector, LanguageServiceContext, Disposable, ProviderResult, FormattingOptions } from '@volar/language-service';
import * as json from 'vscode-json-languageservice';
import type { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'json/jsonDocument': (document: TextDocument) => json.JSONDocument | undefined;
    'json/languageService': () => json.LanguageService;
}
export interface JSONSchemaSettings {
    fileMatch?: string[];
    url?: string;
    schema?: json.JSONSchema;
    folderUri?: string;
}
export declare function create({ documentSelector, getWorkspaceContextService, isFormattingEnabled, getFormattingOptions, getLanguageSettings, getDocumentLanguageSettings, onDidChangeLanguageSettings, }?: {
    documentSelector?: DocumentSelector;
    getWorkspaceContextService?(context: LanguageServiceContext): json.WorkspaceContextService;
    isFormattingEnabled?(document: TextDocument, context: LanguageServiceContext): ProviderResult<boolean>;
    getFormattingOptions?(document: TextDocument, options: FormattingOptions, context: LanguageServiceContext): ProviderResult<json.FormattingOptions>;
    getLanguageSettings?(context: LanguageServiceContext): ProviderResult<json.LanguageSettings>;
    getDocumentLanguageSettings?(document: TextDocument, context: LanguageServiceContext): ProviderResult<json.DocumentLanguageSettings | undefined>;
    onDidChangeLanguageSettings?(listener: () => void, context: LanguageServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map