/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.activity.core;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.activity.core.ActivityManager;
import org.eclipse.mylyn.internal.tasks.activity.core.TaskActivityProvider;
import org.eclipse.mylyn.tasks.activity.core.ActivityEvent;
import org.eclipse.mylyn.tasks.activity.core.ActivityScope;
import org.eclipse.mylyn.tasks.activity.core.IActivityManager;
import org.eclipse.mylyn.tasks.activity.core.IActivityStream;

public class ActivityStream
implements IActivityStream {
    private final Set<ActivityEvent> events;
    private final ActivityScope scope;
    private final ActivityManager manager;

    public ActivityStream(ActivityManager manager, ActivityScope scope) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)scope);
        this.manager = manager;
        this.scope = scope;
        this.events = Collections.synchronizedSet(new TreeSet());
        this.initialize();
    }

    private void initialize() {
        this.events.addAll(this.manager.getEvents(this.scope));
    }

    @Override
    public void query(IProgressMonitor monitor) throws CoreException {
        TaskActivityProvider reviewTaskProvider = new TaskActivityProvider();
        reviewTaskProvider.open(this.manager);
        reviewTaskProvider.query(this.scope, monitor);
        this.initialize();
    }

    public void addEvent(ActivityEvent event) {
        this.events.add(event);
    }

    @Override
    public Set<ActivityEvent> getEvents() {
        return this.events;
    }

    public IActivityManager getManager() {
        return this.manager;
    }

    @Override
    public ActivityScope getScope() {
        return this.scope;
    }

    public void removeEvent(ActivityEvent event) {
        this.events.remove(event);
    }
}

