/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLine;

public class StickyLinesProvider {
    private static final int IGNORE_INDENTATION = -1;
    private static final String TAB = "\t";
    private int tabWidth = 4;

    public List<StickyLine> get(int verticalOffset, ISourceViewer sourceViewer) {
        LinkedList<StickyLine> stickyLines = new LinkedList<StickyLine>();
        if (verticalOffset == 0) {
            return stickyLines;
        }
        try {
            StyledText textWidget = sourceViewer.getTextWidget();
            int startLine = textWidget.getTopIndex();
            this.calculateStickyLinesForLineNumber(stickyLines, sourceViewer, startLine);
            this.calculateStickyLinesUnderStickyLineControl(stickyLines, sourceViewer, startLine);
        }
        catch (IllegalArgumentException e) {
            stickyLines.clear();
        }
        return stickyLines;
    }

    private void calculateStickyLinesForLineNumber(LinkedList<StickyLine> stickyLines, ISourceViewer sourceViewer, int lineNumber) {
        StyledText textWidget = sourceViewer.getTextWidget();
        int startIndetation = this.getStartIndentation(lineNumber, textWidget);
        int i = lineNumber;
        int previousIndetation = startIndetation;
        while (i >= 0) {
            String line = textWidget.getLine(i);
            int indentation = this.getIndentation(line);
            if (indentation != -1 && indentation < previousIndetation) {
                previousIndetation = indentation;
                stickyLines.addFirst(new StickyLine(line, this.mapLineNumberToSourceViewerLine(i, sourceViewer)));
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calculateStickyLinesUnderStickyLineControl(LinkedList<StickyLine> stickyLines, ISourceViewer sourceViewer, int startLine) {
        firstBelowControl = startLine + stickyLines.size();
        textWidget = sourceViewer.getTextWidget();
        lineCount = textWidget.getLineCount();
        i = startLine;
        while (i < firstBelowControl && i < lineCount) {
            block3: {
                line = textWidget.getLine(i);
                indentation = this.getIndentation(line);
                if (indentation != -1) ** GOTO lbl13
                break block3;
lbl-1000:
                // 1 sources

                {
                    stickyLines.removeLast();
                    --firstBelowControl;
lbl13:
                    // 2 sources

                    ** while (!stickyLines.isEmpty() && indentation <= this.getLastStickyLineIndentation(stickyLines) && i < firstBelowControl)
                }
lbl14:
                // 1 sources

                nextContentLine = this.getNextContentLine(i, textWidget);
                if (this.getIndentation(nextContentLine) > indentation && i < firstBelowControl) {
                    stickyLines.addLast(new StickyLine(line, this.mapLineNumberToSourceViewerLine(i, sourceViewer)));
                    ++firstBelowControl;
                }
            }
            ++i;
        }
    }

    private int getLastStickyLineIndentation(LinkedList<StickyLine> stickyLines) {
        String text = stickyLines.getLast().text();
        return this.getIndentation(text);
    }

    private int mapLineNumberToSourceViewerLine(int lineNumber, ISourceViewer sourceViewer) {
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            return extension.widgetLine2ModelLine(lineNumber);
        }
        return lineNumber;
    }

    private int getStartIndentation(int startFromLine, StyledText styledText) {
        int indentation = this.getIndentation(styledText.getLine(startFromLine));
        if (indentation != -1) {
            return indentation;
        }
        int nextContentLine = this.getIndentation(this.getNextContentLine(startFromLine, styledText));
        int previousContentLine = this.getIndentation(this.getPreviousContentLine(startFromLine, styledText));
        return Math.max(nextContentLine, previousContentLine);
    }

    private String getNextContentLine(int startFromLine, StyledText styledText) {
        int i = startFromLine + 1;
        while (i < styledText.getLineCount()) {
            String line = styledText.getLine(i);
            if (!line.isBlank()) {
                return line;
            }
            ++i;
        }
        return null;
    }

    private String getPreviousContentLine(int startFromLine, StyledText styledText) {
        int i = startFromLine - 1;
        while (i >= 0) {
            String line = styledText.getLine(i);
            if (!line.isBlank()) {
                return line;
            }
            --i;
        }
        return null;
    }

    private int getIndentation(String line) {
        if (line == null || line.isBlank()) {
            return -1;
        }
        String tabAsSpaces = String.join((CharSequence)"", Collections.nCopies(this.tabWidth, " "));
        line = line.replace(TAB, tabAsSpaces);
        return line.length() - line.stripLeading().length();
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }
}

