/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.AccessibleObjectFactory;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.VariantUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.ole.win32.Variant;

public class MSAATreeContentProvider
implements ITreeContentProvider {
    private boolean hideHtml = false;
    private boolean showOffscreen = false;
    private static MSAATreeContentProvider instance = new MSAATreeContentProvider();

    public static MSAATreeContentProvider getDefault() {
        if (instance == null) {
            instance = new MSAATreeContentProvider();
        }
        return instance;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof AccessibleObject) {
            AccessibleObject[] accessibleObjectArray = ((AccessibleObject)object).getChildren();
            Vector<AccessibleObject> vector = new Vector<AccessibleObject>();
            int n = 0;
            while (n < accessibleObjectArray.length) {
                AccessibleObject accessibleObject = accessibleObjectArray[n];
                if (accessibleObject != null) {
                    int n2 = accessibleObject.getAccState();
                    if ((n2 & 0x8000) == 0) {
                        vector.add(accessibleObject);
                    } else if (this.showOffscreen && (n2 & 0x10000) != 0) {
                        vector.add(accessibleObject);
                    }
                }
                ++n;
            }
            return vector.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object object) {
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof AccessibleObject) {
            return ((AccessibleObject)object).getChildCount() > 0;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : this.getChildren(object);
        if (this.hideHtml) {
            ArrayList<AccessibleObject> arrayList = new ArrayList<AccessibleObject>();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                if (object2 instanceof AccessibleObject) {
                    FlashMSAAObject flashMSAAObject = FlashMSAAObjectFactory.getFlashMSAAObjectFromWindow((long)((AccessibleObject)object2).getWindow());
                    FlashMSAAObject[] flashMSAAObjectArray = FlashMSAAUtil.getFlashElements((FlashMSAAObject)flashMSAAObject);
                    AccessibleObject[] accessibleObjectArray = new AccessibleObject[flashMSAAObjectArray.length];
                    int n3 = 0;
                    while (n3 < flashMSAAObjectArray.length) {
                        Variant variant = VariantUtil.createVariantFromIDispatchAddress((int)flashMSAAObjectArray[n3].getPtr());
                        accessibleObjectArray[n3] = AccessibleObjectFactory.getAccessibleObjectFromVariant(variant);
                        ++n3;
                    }
                    AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray;
                    int n4 = accessibleObjectArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        AccessibleObject accessibleObject = accessibleObjectArray2[n5];
                        arrayList.add(accessibleObject);
                        ++n5;
                    }
                }
                ++n2;
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object instanceof Object[]) {
            object = ((Object[])object)[0];
        }
        if (object instanceof AccessibleObject) {
            try {
                ((AccessibleObject)object).dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isHideHtml() {
        return this.hideHtml;
    }

    public void setHideHtml(boolean bl) {
        this.hideHtml = bl;
    }

    public boolean isShowOffscreen() {
        return this.showOffscreen;
    }

    public void setShowOffscreen(boolean bl) {
        this.showOffscreen = bl;
        FlashMSAAUtil.setShowOffscreen((boolean)bl);
    }
}

