/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.IHTTPProxy;
import org.eclipse.actf.util.httpproxy.ProxyConfig;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.IObjectPool;
import org.eclipse.actf.util.internal.httpproxy.IWorkpileController;
import org.eclipse.actf.util.internal.httpproxy.ObjectPoolImpl;
import org.eclipse.actf.util.internal.httpproxy.WorkpileControllerImpl;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnectionListener;
import org.eclipse.actf.util.internal.httpproxy.proxy.ClientStateManager;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPProxyConnection;

public class HTTPProxy
implements ClientConnectionListener,
IHTTPProxy {
    private static final Logger LOGGER = Logger.getLogger(HTTPProxy.class);
    private final IWorkpileController wpc;
    private final ServerSocket fServerSock;
    private final long fKeepAlive;
    private final int fQueueSize;
    private final IObjectPool connectionPool;
    private final ISecretManager secretManager;
    private final IHTTPSessionOverriderFactory sessionOverriderFactory;
    private final IHTTPProxyTranscoderFactory proxyTranscoderFactory;
    private final IHTTPLocalServerFactory localServerFactory;
    private ExternalProxyConfig externalProxyConfig;
    private boolean exit = false;
    private ProxyThread proxyThread;
    private static final String USAGE_PARAMS = " <localport>";

    public ISecretManager getSecretManager() {
        return this.secretManager;
    }

    public int getListenPort() {
        return this.fServerSock.getLocalPort();
    }

    public ExternalProxyConfig getExternalProxyConfig() {
        return this.externalProxyConfig;
    }

    public IHTTPSessionOverriderFactory getSessionOverriderFactory() {
        return this.sessionOverriderFactory;
    }

    public IHTTPProxyTranscoderFactory getProxyTranscoderFactory() {
        return this.proxyTranscoderFactory;
    }

    public IHTTPLocalServerFactory getLocalServerFactory() {
        return this.localServerFactory;
    }

    public HTTPProxy(ProxyConfig proxyConfig, ExternalProxyConfig externalProxyConfig) throws IOException {
        Logger.setConfigPropertyName("WaXcoding.conf.logging");
        this.externalProxyConfig = externalProxyConfig;
        this.wpc = new WorkpileControllerImpl("WaXcoding");
        this.fServerSock = new ServerSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", proxyConfig.getPort());
        this.fServerSock.bind(inetSocketAddress);
        this.fKeepAlive = proxyConfig.getKeepAliveInterval();
        this.fQueueSize = proxyConfig.getMaxQueueSize();
        this.connectionPool = new ObjectPoolImpl("WaXcoding-clientconnections");
        int n = 0;
        while (n < proxyConfig.getMaxConnection()) {
            HTTPProxyConnection hTTPProxyConnection = new HTTPProxyConnection(this, this.fQueueSize, proxyConfig.getTimeout());
            this.connectionPool.add(hTTPProxyConnection);
            ++n;
        }
        this.secretManager = proxyConfig.getSecretManager();
        this.sessionOverriderFactory = proxyConfig.getSessionOverriderFactory();
        this.proxyTranscoderFactory = proxyConfig.getProxyTranscoderFactory();
        this.localServerFactory = proxyConfig.getLocalServerFactory();
    }

    public String getSecret(String string, boolean bl) {
        if (this.secretManager == null) {
            return null;
        }
        return this.secretManager.getSecret(string, bl);
    }

    public synchronized int getCurrentServerGroupIndex() {
        return 0;
    }

    public void connectionClosed(IClientConnection iClientConnection) {
        this.connectionPool.add(iClientConnection);
    }

    private void startProxy() {
        LOGGER.info("Started WaXcoding, Listening port " + this.fServerSock.getLocalPort());
        while (true) {
            Socket socket = null;
            try {
                HTTPProxyConnection hTTPProxyConnection = (HTTPProxyConnection)this.connectionPool.take(0);
                socket = this.fServerSock.accept();
                socket.setSoTimeout(1);
                if (this.exit) break;
                hTTPProxyConnection.init(ClientStateManager.getClientStateManager(this), socket, this.fKeepAlive, this.getCurrentServerGroupIndex());
                this.wpc.input(hTTPProxyConnection);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!this.exit) continue;
                LOGGER.info("Stopping WaXcoding...");
            }
            catch (SocketException socketException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(this.wpc.toString());
                continue;
            }
            break;
        }
    }

    private void cleanup() {
        LOGGER.info("...done");
    }

    public void startThread() {
        if (this.proxyThread != null) {
            return;
        }
        this.proxyThread = new ProxyThread();
        this.proxyThread.start();
    }

    public void stopThread() {
        this.proxyThread.exit();
        this.proxyThread = null;
    }

    private static void PRINT_USAGE(String string) {
        if (string != null && string.length() > 0) {
            System.err.println(string);
        }
        System.err.println("Usage: java " + HTTPProxy.class.getName() + USAGE_PARAMS);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            HTTPProxy.PRINT_USAGE(null);
            System.exit(1);
        }
        int n = 0;
        int n2 = Integer.parseInt(stringArray[n++]);
        ProxyConfig proxyConfig = new ProxyConfig();
        ExternalProxyConfig externalProxyConfig = new ExternalProxyConfig();
        try {
            Logger.configure();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            HTTPProxy hTTPProxy = new HTTPProxy(proxyConfig, externalProxyConfig);
            hTTPProxy.startProxy();
        }
        catch (IOException iOException) {
            System.err.println("Port is in use: " + n2);
            System.exit(1);
        }
    }

    private class ProxyThread
    extends Thread {
        private boolean threadExit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void exit() {
            HTTPProxy.this.exit = true;
            ProxyThread proxyThread = this;
            synchronized (proxyThread) {
                while (true) {
                    if (this.threadExit) {
                        return;
                    }
                    this.interrupt();
                    try {
                        HTTPProxy.this.fServerSock.close();
                        this.wait(1000L);
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HTTPProxy.this.startProxy();
            HTTPProxy.this.cleanup();
            ProxyThread proxyThread = this;
            synchronized (proxyThread) {
                this.threadExit = true;
                this.notifyAll();
            }
        }

        ProxyThread() {
            super("ProxyThread");
            this.threadExit = false;
        }
    }
}

