/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.DrawingObjectBaseElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.draw.GElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.svg.DescElement;
import org.eclipse.actf.model.dom.odf.svg.TitleElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DrawingObjectElementImpl
extends DrawingObjectBaseElementImpl
implements DrawingObjectElement {
    private static final long serialVersionUID = -934587640960571482L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0' and local-name()='title')]");
    private static final Object EXP2 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0' and local-name()='desc')]");

    protected DrawingObjectElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    public String getAttrDrawCaptionId() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "caption-id")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "caption-id");
        }
        return null;
    }

    public long getHeight() {
        return -1L;
    }

    public long getWidth() {
        return -1L;
    }

    public long getX() {
        return -1L;
    }

    public long getY() {
        return -1L;
    }

    public void setHeight(long l) {
    }

    public void setWidth(long l) {
    }

    public void setX(long l) {
    }

    public void setY(long l) {
    }

    public long getPageIndex() {
        PageElement pageElement = null;
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof PageElement) {
                pageElement = (PageElement)node;
                break;
            }
            if (node instanceof BodyElement) break;
            node = node.getParentNode();
        }
        if (pageElement != null) {
            return pageElement.getPageIndex();
        }
        Node node2 = null;
        node = this.getParentNode();
        while (node != null) {
            Node node3;
            if (node instanceof TableElement && (node3 = node.getParentNode()) instanceof SpreadSheetElement) {
                node2 = (TableElement)node;
                break;
            }
            if (node instanceof BodyElement) break;
            node = node.getParentNode();
        }
        if (node2 != null) {
            int n = 0;
            Node node4 = node2.getPreviousSibling();
            while (node4 != null) {
                if (node4 instanceof TableElement) {
                    ++n;
                }
                node4 = node4.getPreviousSibling();
            }
            return n;
        }
        return -1L;
    }

    public long getZIndex() {
        DocumentContentElement documentContentElement;
        ODFConstants.ContentType contentType;
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index")) {
            try {
                return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "z-index")).intValue();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((contentType = (documentContentElement = (DocumentContentElement)this.odfDoc.getDocumentElement()).getBodyElement().getContent().getContentType()) == ODFConstants.ContentType.PRESENTATION || contentType == ODFConstants.ContentType.DRAW) {
            Node node = this.getParentNode();
            if (node instanceof PageElement) {
                int n = 0;
                Node node2 = this.getPreviousSibling();
                while (node2 != null) {
                    NodeList nodeList;
                    if (node2 instanceof DrawingObjectElement) {
                        ++n;
                    } else if (node2 instanceof Element && (nodeList = ((Element)node2).getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "control")) != null && nodeList.getLength() > 0) {
                        n += nodeList.getLength();
                    }
                    node2 = node2.getPreviousSibling();
                }
                return n;
            }
            if (node instanceof GElement) {
                return ((GElement)node).getZIndex();
            }
        }
        return -1L;
    }

    public TextBoxElement getBoundCaptionTextBoxElement() {
        ODFDocument oDFDocument = (ODFDocument)this.getOwnerDocument();
        return this.getBoundCaptionTextBoxElement(oDFDocument.getODFVersion());
    }

    public TextBoxElement getBoundCaptionTextBoxElement(double d) {
        if (d == 1.0) {
            return null;
        }
        String string = this.getAttrDrawCaptionId();
        if (string == null) {
            return null;
        }
        ODFDocument oDFDocument = (ODFDocument)this.getOwnerDocument();
        ODFElementImpl oDFElementImpl = (ODFElementImpl)oDFDocument.getDocumentElement();
        ODFElement oDFElement = oDFElementImpl.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "text-box", "urn:oasis:names:tc:opendocument:xmlns:text:1.0", "id", string);
        if (oDFElement != null && oDFElement instanceof TextBoxElement) {
            return (TextBoxElement)oDFElement;
        }
        new ODFException("'draw:caption-id' does not point to text:box element.").printStackTrace();
        return null;
    }

    public TitleElement getSVGTitleElement() {
        NodeList nodeList = xpathService.evalForNodeList(EXP1, (Node)this);
        if (nodeList != null && nodeList.getLength() == 1) {
            return (TitleElement)nodeList.item(0);
        }
        if (nodeList != null && nodeList.getLength() > 1) {
            new ODFException("drawing object has more than one svg:title elements.").printStackTrace();
        }
        return null;
    }

    public DescElement getSVGDescElement() {
        NodeList nodeList = xpathService.evalForNodeList(EXP2, (Node)this);
        if (nodeList != null && nodeList.getLength() == 1) {
            return (DescElement)nodeList.item(0);
        }
        if (nodeList != null && nodeList.getLength() > 1) {
            new ODFException("drawing object has more than one svg:desc elements.").printStackTrace();
        }
        return null;
    }
}

