/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.problem;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;

public class ReportUtil
implements IProblemItemVisitor {
    public static final int CSV = 0;
    public static final int TAB = 1;
    public static final String LINE_SEP = FileUtils.LINE_SEP;
    private static final String COMMA = ",";
    private static final String TAB_STRING = "\t";
    private static final String DOUBLEQUATE = "\"";
    private PrintWriter reportPW;
    private GuidelineHolder gh = GuidelineHolder.getInstance();
    private String[] metricsNames = this.gh.getLocalizedMetricsNames();
    private boolean[] enabledMetrics;
    private String[] guidelineNames = this.gh.getGuidelineNames();
    private boolean[] enabledGuidelines = new boolean[this.guidelineNames.length];
    private HashMap<IEvaluationItem, String> cacheMap = new HashMap();
    private int mode = 0;
    private boolean isCSV = true;
    private String separator = ",";

    public int getMode() {
        return this.mode;
    }

    public ReportUtil() {
        this.enabledMetrics = this.gh.getEnabledMetrics();
        IGuidelineData[] iGuidelineDataArray = this.gh.getGuidelineData();
        int n = 0;
        while (n < iGuidelineDataArray.length) {
            this.enabledGuidelines[n] = iGuidelineDataArray[n].isEnabled();
            ++n;
        }
    }

    public void setMode(int n) {
        switch (n) {
            case 0: {
                this.isCSV = true;
                this.mode = n;
                this.separator = COMMA;
                break;
            }
            case 1: {
                this.isCSV = false;
                this.mode = n;
                this.separator = TAB_STRING;
            }
        }
    }

    public String getFirstLine() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.prep(IProblemConst.TITLE_TYPE)) + this.separator);
        int n = 0;
        while (n < this.metricsNames.length) {
            if (this.enabledMetrics[n]) {
                stringBuffer.append(String.valueOf(this.prep(this.metricsNames[n])) + this.separator);
            }
            ++n;
        }
        n = 0;
        while (n < this.guidelineNames.length) {
            if (this.enabledGuidelines[n]) {
                stringBuffer.append(String.valueOf(this.prep(this.guidelineNames[n])) + this.separator);
            }
            ++n;
        }
        stringBuffer.append(String.valueOf(this.prep(String.valueOf(IProblemConst.TITLE_GUIDELINE) + "(" + IProblemConst.TITLE_HELP + ")")) + this.separator + this.prep(IProblemConst.TITLE_TECHNIQUS) + this.separator + this.prep(String.valueOf(IProblemConst.TITLE_TECHNIQUS) + "(" + IProblemConst.TITLE_HELP + ")") + this.separator + this.prep(IProblemConst.TITLE_LINE) + this.separator + this.prep(IProblemConst.TITLE_DESCRIPTION));
        return stringBuffer.toString();
    }

    public void writeFirstLine() {
        if (this.reportPW != null) {
            this.reportPW.println(this.getFirstLine());
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.reportPW = printWriter;
    }

    private String prep(String string) {
        if (this.isCSV) {
            return DOUBLEQUATE + string.replaceAll(DOUBLEQUATE, "\"\"") + DOUBLEQUATE;
        }
        return string.replaceAll(TAB_STRING, "    ");
    }

    public String toString(IProblemItem iProblemItem) {
        if (iProblemItem == null) {
            return "";
        }
        IEvaluationItem iEvaluationItem = iProblemItem.getEvaluationItem();
        String string = this.cacheMap.get(iEvaluationItem);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(this.prep(iProblemItem.getSeverityStr())) + this.separator);
            int[] nArray = iEvaluationItem.getMetricsScores();
            int n = 0;
            while (n < nArray.length) {
                if (this.enabledMetrics[n]) {
                    stringBuffer.append(String.valueOf(this.prep(Integer.toString(-nArray[n]))) + this.separator);
                }
                ++n;
            }
            String[] stringArray = iEvaluationItem.getTableDataGuideline();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.enabledGuidelines[n2]) {
                    stringBuffer.append(String.valueOf(this.prep(stringArray[n2])) + this.separator);
                }
                ++n2;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            ITechniquesItem[][] iTechniquesItemArray = iEvaluationItem.getTechniques();
            IGuidelineItem[] iGuidelineItemArray = iEvaluationItem.getGuidelines();
            TreeSet<ITechniquesItem> treeSet = new TreeSet<ITechniquesItem>(new Comparator<ITechniquesItem>(){

                @Override
                public int compare(ITechniquesItem iTechniquesItem, ITechniquesItem iTechniquesItem2) {
                    int n = iTechniquesItem.getGuidelineName().compareTo(iTechniquesItem2.getGuidelineName());
                    if (n == 0) {
                        n = iTechniquesItem.getId().compareTo(iTechniquesItem2.getId());
                    }
                    return n;
                }
            });
            int n3 = 0;
            while (n3 < iGuidelineItemArray.length) {
                IGuidelineItem iGuidelineItem = iGuidelineItemArray[n3];
                if (iGuidelineItem.isEnabled()) {
                    stringBuffer2.append(String.valueOf(iGuidelineItem.getUrl()) + this.separator + " ");
                    ITechniquesItem[] iTechniquesItemArray2 = iTechniquesItemArray[n3];
                    int n4 = iTechniquesItemArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ITechniquesItem iTechniquesItem = iTechniquesItemArray2[n5];
                        treeSet.add(iTechniquesItem);
                        ++n5;
                    }
                }
                ++n3;
            }
            for (ITechniquesItem iTechniquesItem : treeSet) {
                stringBuffer3.append(String.valueOf(iTechniquesItem.getUrl()) + this.separator + " ");
            }
            String string2 = stringBuffer2.toString();
            if (string2.length() > 2) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            stringBuffer.append(String.valueOf(this.prep(string2)) + this.separator);
            stringBuffer.append(String.valueOf(this.prep(iProblemItem.getEvaluationItem().getTableDataTechniques())) + this.separator);
            string2 = stringBuffer3.toString();
            if (string2.length() > 2) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            stringBuffer.append(String.valueOf(this.prep(string2)) + this.separator);
            string = stringBuffer.toString();
            this.cacheMap.put(iEvaluationItem, string);
        }
        return String.valueOf(string) + this.prep(iProblemItem.getLineStrMulti()) + this.separator + this.prep(iProblemItem.getDescription());
    }

    public void visit(IProblemItem iProblemItem) {
        if (iProblemItem != null) {
            this.reportPW.println(this.toString(iProblemItem));
        }
    }
}

