/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.IModelServiceScrollManager;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.visualization.ui.IPositionSize;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationCanvas
extends Canvas {
    private final Display display;
    private Image image = null;
    private ImageData imageData = null;
    private int curX;
    private int curY;
    private ScrollBar horizontalBar;
    private ScrollBar verticalBar;
    private List<IPositionSize> highlightTargetList = new ArrayList<IPositionSize>();
    private IModelService current = null;
    private IModelService target = null;
    private String targetUrl = null;
    private boolean sync = true;

    public VisualizationCanvas(Composite composite) {
        this(composite, 0);
    }

    public VisualizationCanvas(Composite composite, int n) {
        super(composite, 0x300 | n);
        this.display = composite.getDisplay();
        this.init();
        composite.getShell().addListener(100, new Listener(){

            public void handleEvent(Event event) {
                VisualizationCanvas.this.setVScrollBar(event.detail);
            }
        });
    }

    private void init() {
        this.setBackground(new Color((Device)this.display, 255, 255, 255));
        this.curX = 0;
        this.curY = 0;
        this.horizontalBar = this.getHorizontalBar();
        this.horizontalBar.setVisible(true);
        this.horizontalBar.setMinimum(0);
        this.horizontalBar.setEnabled(false);
        this.horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VisualizationCanvas.this.scrollHorizontally((ScrollBar)selectionEvent.widget);
            }
        });
        this.verticalBar = this.getVerticalBar();
        this.verticalBar.setVisible(true);
        this.verticalBar.setMinimum(0);
        this.verticalBar.setEnabled(false);
        this.verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VisualizationCanvas.this.scrollVertically((ScrollBar)selectionEvent.widget);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (VisualizationCanvas.this.imageData == null) {
                    return;
                }
                if (VisualizationCanvas.this.image != null) {
                    VisualizationCanvas.this.paintImage(paintEvent);
                }
                VisualizationCanvas.this.resizeScrollBars();
            }
        });
    }

    private void paintImage(PaintEvent paintEvent) {
        if (this.image == null || this.imageData == null) {
            return;
        }
        Image image = this.image;
        int n = Math.round(this.imageData.width);
        int n2 = Math.round(this.imageData.height);
        paintEvent.gc.drawImage(image, 0, 0, this.imageData.width, this.imageData.height, this.curX + this.imageData.x, this.curY + this.imageData.y, n, n2);
        List<IPositionSize> list = this.highlightTargetList;
        if (list != null) {
            paintEvent.gc.setLineWidth(2);
            for (IPositionSize iPositionSize : list) {
                paintEvent.gc.setForeground(this.display.getSystemColor(1));
                paintEvent.gc.drawRectangle(this.curX + iPositionSize.getX(), this.curY + iPositionSize.getY(), iPositionSize.getWidth(), iPositionSize.getHeight());
                paintEvent.gc.setForeground(this.display.getSystemColor(2));
                paintEvent.gc.drawRectangle(this.curX + iPositionSize.getX() - 2, this.curY + iPositionSize.getY() - 2, iPositionSize.getWidth() + 4, iPositionSize.getHeight() + 4);
            }
        }
    }

    protected void resetScrollBars() {
        if (this.image == null) {
            this.horizontalBar.setEnabled(false);
            this.verticalBar.setEnabled(false);
            return;
        }
        this.curX = 0;
        this.curY = 0;
        this.resizeScrollBars();
        this.horizontalBar.setSelection(0);
        this.verticalBar.setSelection(0);
    }

    private void resizeScrollBars() {
        if (this.imageData == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        int n = Math.round(this.imageData.width);
        if (n > rectangle.width) {
            this.horizontalBar.setEnabled(true);
            this.horizontalBar.setMaximum(n);
            this.horizontalBar.setThumb(rectangle.width);
            this.horizontalBar.setPageIncrement(rectangle.width);
        } else {
            this.horizontalBar.setEnabled(false);
            if (this.curX != 0) {
                this.curX = 0;
                this.redraw();
            }
        }
        int n2 = Math.round(this.imageData.height);
        if (n2 > rectangle.height) {
            this.verticalBar.setEnabled(true);
            this.verticalBar.setMaximum(n2);
            this.verticalBar.setThumb(rectangle.height);
            this.verticalBar.setPageIncrement(rectangle.height);
        } else {
            this.verticalBar.setEnabled(false);
            if (this.curY != 0) {
                this.curY = 0;
                this.redraw();
            }
        }
    }

    private void setVScrollBar(int n) {
        if (this.sync) {
            if (this.image == null) {
                return;
            }
            int n2 = Math.round(this.imageData.width);
            int n3 = Math.round(this.imageData.height);
            this.scroll(this.curX, -n, this.curX, this.curY, n2, n3, false);
            this.curY = -n;
            this.verticalBar.setSelection(n);
        }
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.image == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        int n = Math.round(this.imageData.width);
        int n2 = Math.round(this.imageData.height);
        if (n > rectangle.width) {
            int n3 = -scrollBar.getSelection();
            if (n3 + n < rectangle.width) {
                n3 = rectangle.width - n;
            }
            this.scroll(n3, this.curY, this.curX, this.curY, n, n2, false);
            this.curX = n3;
        }
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.image != null) {
            Rectangle rectangle = this.getClientArea();
            int n = Math.round(this.imageData.width);
            int n2 = Math.round(this.imageData.height);
            if (n2 > rectangle.height) {
                int n3 = -scrollBar.getSelection();
                if (n3 + n2 < rectangle.height) {
                    n3 = rectangle.height - n2;
                }
                this.scroll(this.curX, n3, this.curX, this.curY, n, n2, false);
                if (this.sync && this.current != null && this.current == this.target && this.targetUrl.equals(this.target.getURL())) {
                    IModelServiceScrollManager iModelServiceScrollManager = this.target.getScrollManager();
                    switch (iModelServiceScrollManager.getScrollType()) {
                        case 0: {
                            int n4 = iModelServiceScrollManager.getSize(true).getWholeSizeY();
                            double d = (double)n4 / (double)(n2 - this.horizontalBar.getSize().y);
                            iModelServiceScrollManager.absoluteCoordinateScroll((int)((double)(this.curY - n3) * d), false);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            ModelServiceSizeInfo modelServiceSizeInfo = iModelServiceScrollManager.getSize(false);
                            int n5 = Math.abs(n3 / modelServiceSizeInfo.getViewSizeY()) + 1;
                            if (n5 < 1) {
                                n5 = 1;
                            } else if (n5 > iModelServiceScrollManager.getLastPageNumber()) {
                                n5 = iModelServiceScrollManager.getCurrentPageNumber();
                            }
                            if (n5 == iModelServiceScrollManager.getCurrentPageNumber()) break;
                            iModelServiceScrollManager.jumpToPage(n5, false);
                        }
                    }
                }
                this.curY = n3;
            }
        }
    }

    public void setCurrentModelService(IModelService iModelService) {
        this.current = iModelService;
    }

    public void showImage(ImageData imageData, IModelService iModelService) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.imageData = imageData;
        this.target = iModelService;
        if (this.current == null) {
            this.current = this.target;
        }
        this.targetUrl = this.target != null ? this.target.getURL() : null;
        if (this.imageData != null) {
            try {
                this.image = new Image((Device)this.display, this.imageData);
            }
            catch (SWTException sWTException) {
                sWTException.printStackTrace();
            }
        }
        this.redraw();
        this.resetScrollBars();
    }

    public void clear() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        if (this.imageData != null) {
            this.imageData = null;
        }
        this.highlightTargetList = new ArrayList<IPositionSize>();
        this.resetScrollBars();
        this.redraw();
    }

    public void highlight(List<IPositionSize> list) {
        if (list != null) {
            int n = -1;
            for (IPositionSize iPositionSize : list) {
                if (n >= 0 && n <= iPositionSize.getY()) continue;
                n = iPositionSize.getY();
            }
            if (n >= 0) {
                IPositionSize iPositionSize;
                iPositionSize = this.getClientArea();
                int n2 = Math.round(this.imageData.height);
                if (n2 > ((Rectangle)iPositionSize).height) {
                    if (n2 - n < ((Rectangle)iPositionSize).height) {
                        n = n2 - ((Rectangle)iPositionSize).height;
                    }
                    this.setVScrollBar(n);
                }
            }
            this.highlightTargetList = list;
        }
        this.redraw();
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }
}

