/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.graphmap.GraphMapPreferences;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GraphMapRegistry {
    private static volatile GraphMapRegistry instance;
    private List<GraphMapView> registeredViews = new ArrayList<GraphMapView>();

    private GraphMapRegistry() {
        SimulationManager simMan = SimulationManager.getManager();
        simMan.addSimulationManagerListener((ISimulationManagerListener)new SimulationManagerListener());
    }

    public static final synchronized GraphMapRegistry getInstance() {
        if (instance == null) {
            instance = new GraphMapRegistry();
        }
        return instance;
    }

    public boolean registerView(GraphMapView view) {
        if (this.registeredViews.contains(view)) {
            return false;
        }
        return this.registeredViews.add(view);
    }

    public int getViewId(GraphMapView view) {
        return this.registeredViews.indexOf(view);
    }

    public void unRegisterView(GraphMapView view) {
        this.registeredViews.remove(view);
    }

    private class SimulationManagerListener
    implements ISimulationManagerListener {
        private SimulationManagerListener() {
        }

        public void simulationsChanged(SimulationManagerEvent event) {
            GraphMapPreferences prefs = GraphMapPreferences.getInstance();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            int mxViews = 0;
            ISimulation[] iSimulationArray = event.getSimulationsAdded();
            int n = iSimulationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISimulation sim = iSimulationArray[n2];
                int x = prefs.getNoOfPreferencesForScenario(sim.getScenario().getURI().toString());
                if (x > mxViews) {
                    mxViews = x;
                }
                ++n2;
            }
            block3: while (mxViews-- > GraphMapRegistry.this.registeredViews.size()) {
                int i = 1;
                while (true) {
                    if (page.findViewReference("org.eclipse.stem.ui.views.graphmap", "" + i) == null) {
                        try {
                            page.showView("org.eclipse.stem.ui.views.graphmap", "" + i, 1);
                        }
                        catch (PartInitException e1) {
                            Activator.logError("Could not instantiate new GraphMapView", e1);
                        }
                        continue block3;
                    }
                    ++i;
                }
            }
        }
    }
}

