/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.ui.wizards.ModelCompartmentsPage;
import org.eclipse.stem.model.ui.wizards.ModelParametersPage;
import org.eclipse.stem.model.ui.wizards.ModelPropertiesPage;
import org.eclipse.swt.widgets.Shell;

public class NewModelWizard
extends Wizard {
    protected ModelPropertiesPage propertiesPage;
    protected ModelParametersPage parametersPage;
    protected ModelCompartmentsPage compartmentsPage;
    protected Model newModel;

    public NewModelWizard(Model model) {
        this.setNeedsProgressMonitor(true);
        this.newModel = model;
    }

    public Model getModel() {
        return this.newModel;
    }

    public void addPages() {
        this.propertiesPage = new ModelPropertiesPage(this.newModel);
        this.parametersPage = new ModelParametersPage(this.newModel);
        this.compartmentsPage = new ModelCompartmentsPage(this.newModel);
        this.addPage((IWizardPage)this.propertiesPage);
        this.addPage((IWizardPage)this.parametersPage);
        this.addPage((IWizardPage)this.compartmentsPage);
    }

    public boolean performFinish() {
        this.propertiesPage.formatTextFields();
        boolean valid = true;
        String errorMessage = null;
        if (valid && !this.propertiesPage.validatePage()) {
            errorMessage = this.propertiesPage.getErrorMessage();
            valid = false;
        }
        if (valid && !this.compartmentsPage.validatePage()) {
            errorMessage = this.compartmentsPage.getErrorMessage();
            valid = false;
        }
        if (!valid) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error saving the model: " + errorMessage));
            return false;
        }
        return true;
    }
}

